/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.validation;

import com.vdurmont.semver4j.Semver;
import de.skuzzle.semantic.Version;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.mule.tools.api.exception.ValidationException;

public class VersionUtils {
    private static final String NULL_VERSION = "0.0.0";

    private VersionUtils() {
    }

    public static Boolean isVersionValid(String version) {
        return !StringUtils.equals((CharSequence)version, (CharSequence)NULL_VERSION) && Version.isValidVersion((String)version);
    }

    public static Boolean isVersionGreaterOrEquals(String version1, String version2) throws ValidationException {
        String v1 = VersionUtils.completeIncremental(version1);
        String v2 = VersionUtils.completeIncremental(version2);
        return Version.parseVersion((String)v1).compareTo(Version.parseVersion((String)v2)) >= 0;
    }

    public static String completeIncremental(String version) throws ValidationException {
        Semver semver = new Semver(version, Semver.SemverType.LOOSE);
        Optional<Integer> minor = Optional.ofNullable(semver.getMinor());
        Optional<Integer> patch = Optional.ofNullable(semver.getPatch());
        if (!minor.isPresent() || !patch.isPresent()) {
            version = Version.create((int)semver.getMajor(), (int)minor.orElse(0), (int)patch.orElse(0)).toString();
        }
        if (!VersionUtils.isVersionValid(version).booleanValue()) {
            throw new ValidationException("Version is invalid: " + version);
        }
        return VersionUtils.getBaseVersion(version);
    }

    public static String getBaseVersion(String version) {
        return new Semver(version).withClearedSuffixAndBuild().getValue();
    }

    public static String getMajor(String version) {
        return String.valueOf(new Semver(version).getMajor());
    }

    public static boolean isRange(String version) {
        return Pattern.matches("^[\\[(].*[])]$", version);
    }
}

