/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.revapi.transform;

import java.io.Reader;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleTypeVisitor8;
import javax.lang.model.util.Types;
import org.mule.tools.revapi.transform.DifferenceChecker;
import org.revapi.AnalysisContext;
import org.revapi.Difference;
import org.revapi.DifferenceTransform;
import org.revapi.Element;

public abstract class AbstractApiAnnotationTransform
implements DifferenceTransform {
    private final String id;
    private final Map<String, DifferenceChecker> checkers;

    AbstractApiAnnotationTransform(String id) {
        this.id = id;
        this.checkers = this.getDifferenceCheckers();
    }

    public Difference transform(Element oldElement, Element newElement, Difference difference) {
        DifferenceChecker differenceChecker = this.checkers.get(difference.code);
        if (differenceChecker != null && differenceChecker.ignore(oldElement, newElement)) {
            return null;
        }
        return difference;
    }

    public void close() throws Exception {
    }

    public Reader getJSONSchema() {
        return null;
    }

    public void initialize(AnalysisContext analysisContext) {
    }

    public String getExtensionId() {
        return this.id;
    }

    public Pattern[] getDifferenceCodePatterns() {
        LinkedList<Pattern> patterns = new LinkedList<Pattern>();
        for (String code : this.getDifferenceCodes()) {
            patterns.add(this.getPatternFor(code));
        }
        return patterns.toArray(new Pattern[0]);
    }

    protected abstract String[] getDifferenceCodes();

    protected abstract Map<String, DifferenceChecker> getDifferenceCheckers();

    private Pattern getPatternFor(String code) {
        return Pattern.compile("^" + Pattern.quote(code) + "$");
    }

    boolean isTypeWithAnnotation(Types types, TypeMirror type, SimpleTypeVisitor8<Boolean, Void> checker) {
        if (type.accept(checker, null).booleanValue()) {
            return true;
        }
        List<? extends TypeMirror> superTypes = types.directSupertypes(type);
        for (TypeMirror typeMirror : superTypes) {
            if (typeMirror.accept(checker, null).booleanValue()) {
                return true;
            }
            if (!this.isTypeWithAnnotation(types, typeMirror, checker)) continue;
            return true;
        }
        return false;
    }
}

