/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.revapi.transform;

import java.util.HashMap;
import java.util.Map;
import org.mule.api.annotation.NoImplement;
import org.mule.tools.revapi.transform.AbstractApiAnnotationTransform;
import org.mule.tools.revapi.transform.DifferenceChecker;
import org.mule.tools.revapi.transform.InterfaceVisitor;
import org.revapi.java.model.TypeElement;
import org.revapi.java.spi.Code;

public class NoImplementApiAnnotationTransform
extends AbstractApiAnnotationTransform {
    public NoImplementApiAnnotationTransform() {
        super("mule.revapi.api.ignoreNoImplement");
    }

    @Override
    protected String[] getDifferenceCodes() {
        return new String[]{Code.METHOD_ADDED_TO_INTERFACE.code()};
    }

    @Override
    protected Map<String, DifferenceChecker> getDifferenceCheckers() {
        HashMap<String, DifferenceChecker> checkers = new HashMap<String, DifferenceChecker>();
        DifferenceChecker methodChecker = (oldElement, newElement) -> this.hasNoImplementAnnotation((TypeElement)newElement.getParent());
        checkers.put(Code.METHOD_ADDED_TO_INTERFACE.code(), methodChecker);
        return checkers;
    }

    private boolean hasNoImplementAnnotation(TypeElement typeElement) {
        return this.isTypeWithAnnotation(typeElement.getTypeEnvironment().getTypeUtils(), typeElement.getModelRepresentation(), new InterfaceVisitor(NoImplement.class));
    }
}

