/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.revapi.transform;

import java.util.HashMap;
import java.util.Map;
import org.mule.api.annotation.NoExtend;
import org.mule.tools.revapi.transform.AbstractClassApiAnnotationTransform;
import org.mule.tools.revapi.transform.ClassVisitor;
import org.mule.tools.revapi.transform.DifferenceChecker;
import org.revapi.java.model.TypeElement;
import org.revapi.java.spi.Code;

public class NoExtendApiAnnotationTransform
extends AbstractClassApiAnnotationTransform {
    public NoExtendApiAnnotationTransform() {
        super("mule.revapi.api.ignoreNoExtend");
    }

    @Override
    protected Map<String, DifferenceChecker> getDifferenceCheckers() {
        HashMap<String, DifferenceChecker> checkers = new HashMap<String, DifferenceChecker>();
        DifferenceChecker fieldChecker = (oldElement, newElement) -> this.isProtectedField(oldElement) && this.hasNoExtendAnnotation((TypeElement)oldElement.getParent());
        checkers.put(Code.FIELD_REMOVED.code(), fieldChecker);
        checkers.put(Code.FIELD_TYPE_CHANGED.code(), fieldChecker);
        DifferenceChecker methodChecker = (oldElement, newElement) -> this.isProtectedMethod(oldElement) && this.hasNoExtendAnnotation((TypeElement)oldElement.getParent());
        checkers.put(Code.METHOD_REMOVED.code(), methodChecker);
        checkers.put(Code.METHOD_NUMBER_OF_PARAMETERS_CHANGED.code(), methodChecker);
        checkers.put(Code.METHOD_RETURN_TYPE_CHANGED.code(), methodChecker);
        DifferenceChecker methodAddedChecker = (oldElement, newElement) -> this.isProtectedConstructor(newElement) && this.hasNoExtendAnnotation((TypeElement)newElement.getParent());
        checkers.put(Code.METHOD_ADDED.code(), methodAddedChecker);
        DifferenceChecker paramTypeChecker = (oldElement, newElement) -> this.isProtectedMethod(oldElement.getParent()) && this.hasNoExtendAnnotation((TypeElement)oldElement.getParent().getParent());
        checkers.put(Code.METHOD_PARAMETER_TYPE_CHANGED.code(), paramTypeChecker);
        return checkers;
    }

    private boolean hasNoExtendAnnotation(TypeElement typeElement) {
        return this.isTypeWithAnnotation(typeElement.getTypeEnvironment().getTypeUtils(), typeElement.getModelRepresentation(), new ClassVisitor(NoExtend.class));
    }
}

