/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.revapi;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.revapi.API;
import org.revapi.AnalysisContext;
import org.revapi.Archive;
import org.revapi.Element;
import org.revapi.ElementFilter;
import org.revapi.java.model.TypeElement;
import org.revapi.java.spi.JavaTypeElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExportPackageFilter
implements ElementFilter {
    private static final String EXPORTED_CLASS_PACKAGES_PROPERTY = "artifact.export.classPackages";
    private static final String PRIVILEGED_EXPORTED_CLASS_PACKAGES_PROPERTY = "artifact.privileged.classPackages";
    private static final Logger LOG = LoggerFactory.getLogger(ExportPackageFilter.class);
    private Map<API, Set<String>> exportedPackages;
    private Map<Element, Boolean> exportedElements = new HashMap<Element, Boolean>();

    public void close() {
    }

    private static boolean isVerboseLogging() {
        return System.getProperty("mule.revapi.verbose") != null;
    }

    public String getExtensionId() {
        return "mule.module.filter";
    }

    public Reader getJSONSchema() {
        return null;
    }

    public void initialize(AnalysisContext analysisContext) {
        this.exportedPackages = new HashMap<API, Set<String>>();
        Function<API, Set> getExportedPackages = api -> {
            HashSet exportedPackages = new HashSet();
            api.getArchives().forEach(a -> this.addExportedPackages((Archive)a, exportedPackages));
            return exportedPackages;
        };
        this.exportedPackages.computeIfAbsent(analysisContext.getOldApi(), getExportedPackages);
        this.exportedPackages.computeIfAbsent(analysisContext.getNewApi(), getExportedPackages);
    }

    public boolean applies(Element element) {
        boolean exported;
        if (element instanceof JavaTypeElement) {
            exported = this.isExported(element);
        } else {
            TypeElement ownerJavaTypeElement = this.findOwnerJavaTypeElement(element);
            exported = this.isExported((Element)ownerJavaTypeElement);
        }
        if (ExportPackageFilter.isVerboseLogging()) {
            LOG.info(exported + " : applies to " + String.valueOf(element));
        }
        return exported;
    }

    public boolean shouldDescendInto(Object element) {
        boolean descendInto;
        boolean bl = descendInto = element instanceof Element ? this.isExported((Element)element) : false;
        if (ExportPackageFilter.isVerboseLogging()) {
            LOG.info(descendInto + ": should descend into " + String.valueOf(element));
        }
        return descendInto;
    }

    private TypeElement findOwnerJavaTypeElement(Element element) {
        while (!(element instanceof JavaTypeElement) || element.getParent() instanceof TypeElement) {
            element = element.getParent();
        }
        if (!(element instanceof JavaTypeElement)) {
            throw new IllegalStateException("Cannot find the parent type element for: " + String.valueOf(element));
        }
        return (TypeElement)element;
    }

    private boolean isExported(Element element) {
        boolean exported;
        if (this.exportedElements.containsKey(element)) {
            return this.exportedElements.get(element);
        }
        if (!(element instanceof TypeElement)) {
            exported = false;
        } else {
            String packageName = this.getPackageName((TypeElement)element);
            Set<String> exportDefinitions = this.exportedPackages.get(element.getApi());
            exported = exportDefinitions == null || exportDefinitions.isEmpty() ? false : exportDefinitions.contains(packageName);
        }
        if (ExportPackageFilter.isVerboseLogging()) {
            LOG.info(exported + " : applies to " + String.valueOf(element));
        }
        this.exportedElements.put(element, exported);
        return exported;
    }

    private String getPackageName(TypeElement element) {
        String canonicalName = this.findOwnerJavaTypeElement((Element)element).getCanonicalName();
        int index = canonicalName.lastIndexOf(".");
        return canonicalName.substring(0, index);
    }

    private byte[] getBytes(InputStream is) throws IOException {
        int n;
        byte[] buffer = new byte[8192];
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(2048);
        while ((n = is.read(buffer, 0, buffer.length)) != -1) {
            outputStream.write(buffer, 0, n);
        }
        return outputStream.toByteArray();
    }

    private void addExportedPackages(Archive archive, Set<String> exportedPackages) {
        try (JarInputStream jarFile = new JarInputStream(archive.openStream());){
            JarEntry entry;
            while ((entry = jarFile.getNextJarEntry()) != null) {
                String name = entry.getName();
                if (!name.equals("META-INF/mule-module.properties")) continue;
                Properties properties = new Properties();
                byte[] bytes = this.getBytes(new BufferedInputStream(jarFile));
                properties.load(new ByteArrayInputStream(bytes));
                Set<String> standardPackages = this.getPackagesFromProperty(properties, EXPORTED_CLASS_PACKAGES_PROPERTY);
                exportedPackages.addAll(standardPackages);
                Set<String> privilegedPackages = this.getPackagesFromProperty(properties, PRIVILEGED_EXPORTED_CLASS_PACKAGES_PROPERTY);
                exportedPackages.addAll(privilegedPackages);
                if (!ExportPackageFilter.isVerboseLogging()) continue;
                LOG.info("Adding exported packages from: " + String.valueOf(jarFile) + "\nstandard: " + String.valueOf(standardPackages) + "\nprivileged: " + String.valueOf(privilegedPackages));
            }
        }
        catch (IOException e) {
            LOG.debug("Failed to open the archive " + String.valueOf(archive) + " as a jar.", (Throwable)e);
        }
    }

    private Set<String> getPackagesFromProperty(Properties properties, String propertyName) {
        HashSet<String> result = new HashSet<String>();
        String property = properties.getProperty(propertyName);
        if (property != null) {
            String[] packages;
            for (String packageName : packages = property.split(",")) {
                String name = packageName.trim();
                if ("".equals(name)) continue;
                result.add(name);
            }
        }
        return result;
    }
}

