/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.Scanner;
import org.mule.tools.apikit.Scaffolder;
import org.mule.tools.apikit.model.RuntimeEdition;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="create")
public class CreateMojo
extends AbstractMojo {
    @Component
    private BuildContext buildContext;
    @Parameter
    private String[] specIncludes = new String[]{"src/main/resources/api/**/*.yaml", "src/main/resources/api/**/*.yml", "src/main/resources/api/**/*.raml", "src/main/resources/api/**/*.json"};
    @Parameter
    private String[] specExcludes = new String[0];
    @Parameter(defaultValue="${basedir}")
    private File specDirectory;
    @Parameter
    private String[] muleXmlIncludes = new String[]{"src/main/mule/**/*.xml", "src/main/resources/**/*.xml"};
    @Parameter
    private String[] muleXmlExcludes = new String[0];
    @Parameter(defaultValue="${basedir}")
    private File muleXmlDirectory;
    @Parameter(defaultValue="${basedir}/src/main/mule")
    private File muleXmlOutputDirectory;
    @Parameter(property="domainDirectory")
    private File domainDirectory;
    @Parameter(property="minMuleVersion")
    private String minMuleVersion;
    @Parameter(property="runtimeEdition", defaultValue="CE")
    private String runtimeEdition;
    private Log log;

    List<String> getIncludedFiles(File sourceDirectory, String[] includes, String[] excludes) {
        Scanner scanner = this.buildContext.newScanner(sourceDirectory, true);
        scanner.setIncludes(includes);
        scanner.setExcludes(excludes);
        scanner.scan();
        String[] includedFiles = scanner.getIncludedFiles();
        for (int i = 0; i < includedFiles.length; ++i) {
            includedFiles[i] = new File(scanner.getBasedir(), includedFiles[i]).getAbsolutePath();
        }
        String[] result = new String[includedFiles.length];
        System.arraycopy(includedFiles, 0, result, 0, includedFiles.length);
        return Arrays.asList(result);
    }

    public void execute() throws MojoExecutionException {
        Validate.notNull((Object)this.muleXmlDirectory, (String)"Error: muleXmlDirectory parameter cannot be null");
        Validate.notNull((Object)this.specDirectory, (String)"Error: specDirectory parameter cannot be null");
        this.log = this.getLog();
        List<String> specFiles = this.getIncludedFiles(this.specDirectory, this.specIncludes, this.specExcludes);
        List<String> muleXmlFiles = this.getIncludedFiles(this.muleXmlDirectory, this.muleXmlIncludes, this.muleXmlExcludes);
        String domainFile = this.processDomain();
        if (this.minMuleVersion != null) {
            this.log.info((CharSequence)("Mule version provided: " + this.minMuleVersion));
        }
        this.log.info((CharSequence)("Processing the following RAML files: " + specFiles));
        this.log.info((CharSequence)("Processing the following xml files as mule configs: " + muleXmlFiles));
        try {
            RuntimeEdition muleRuntimeEdition = RuntimeEdition.valueOf((String)this.runtimeEdition);
            Scaffolder scaffolder = Scaffolder.createScaffolder((Log)this.log, (File)this.muleXmlOutputDirectory, specFiles, muleXmlFiles, (String)domainFile, (String)this.minMuleVersion, (RuntimeEdition)muleRuntimeEdition);
            scaffolder.run();
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage());
        }
    }

    private String processDomain() {
        String domainFile = null;
        if (this.domainDirectory != null) {
            List<String> domainFiles = this.getIncludedFiles(this.domainDirectory, new String[]{"*.xml"}, new String[0]);
            if (domainFiles.size() > 0) {
                domainFile = domainFiles.get(0);
                if (domainFiles.size() > 1) {
                    this.log.info((CharSequence)("There is more than one domain file inside of the domain folder. The domain: " + domainFile + " will be used."));
                }
            } else {
                this.log.error((CharSequence)("The specified domain directory [" + this.domainDirectory + "] does not contain any xml file."));
            }
        } else {
            this.log.info((CharSequence)"No domain was provided. To send it, use -DdomainDirectory.");
        }
        return domainFile;
    }
}

