/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.metadata;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.json.api.JsonExampleTypeLoader;
import org.mule.metadata.json.api.JsonTypeLoader;
import org.mule.metadata.xml.api.ModelFactory;
import org.mule.metadata.xml.api.SchemaCollector;
import org.mule.metadata.xml.api.XmlTypeLoader;
import org.mule.metadata.xml.api.utils.XmlSchemaUtils;
import org.mule.raml.interfaces.model.parameter.IParameter;

public class MetadataFactory {
    private static final MetadataType DEFAULT_METADATA = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).anyType().build();
    private static final MetadataType STRING_METADATA = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).stringType().build();

    private MetadataFactory() {
    }

    public static MetadataType fromJsonSchema(String jsonSchema) {
        JsonTypeLoader jsonTypeLoader = new JsonTypeLoader(jsonSchema);
        Optional root = jsonTypeLoader.load(null);
        return root.orElse(MetadataFactory.defaultMetadata());
    }

    public static MetadataType fromJsonExample(String jsonExample) {
        Optional root = Optional.empty();
        JsonExampleTypeLoader jsonExampleTypeLoader = new JsonExampleTypeLoader(jsonExample);
        root = jsonExampleTypeLoader.load(null);
        return root.orElse(MetadataFactory.defaultMetadata());
    }

    public static MetadataType fromXSDSchema(String xsdSchema, String example) {
        Optional rootElementName = XmlSchemaUtils.getXmlSchemaRootElementName(Collections.singletonList(xsdSchema), (String)example);
        return rootElementName.map(qName -> {
            XmlTypeLoader xmlTypeLoader = new XmlTypeLoader(SchemaCollector.getInstance().addSchema("", xsdSchema));
            return xmlTypeLoader.load(qName.toString()).orElse(MetadataFactory.defaultMetadata());
        }).orElse(MetadataFactory.defaultMetadata());
    }

    public static MetadataType fromXMLExample(String xmlExample) {
        ModelFactory modelFactory = ModelFactory.fromExample((String)xmlExample);
        Optional metadata = new XmlTypeLoader(modelFactory).load(null);
        return metadata.orElse(MetadataFactory.defaultMetadata());
    }

    public static MetadataType fromFormMetadata(Map<String, List<IParameter>> formParameters) {
        ObjectTypeBuilder parameters = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).objectType();
        for (Map.Entry<String, List<IParameter>> entry : formParameters.entrySet()) {
            parameters.addField().key(entry.getKey()).value().anyType();
        }
        return parameters.build();
    }

    public static MetadataType defaultMetadata() {
        return DEFAULT_METADATA;
    }

    public static MetadataType stringMetadata() {
        return STRING_METADATA;
    }

    public static MetadataType objectMetadata() {
        return BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).objectType().build();
    }

    public static MetadataType binaryMetadata() {
        return BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).binaryType().build();
    }
}

