/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.metadata.model;

import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.mule.module.apikit.metadata.interfaces.Notifier;
import org.mule.module.apikit.metadata.model.FlowMapping;
import org.mule.module.apikit.metadata.raml.RamlApiWrapper;
import org.mule.raml.interfaces.model.IRaml;

public class ApikitConfig {
    private final String name;
    private final String raml;
    private final List<FlowMapping> flowMappings;
    private final Supplier<Optional<IRaml>> apiSupplier;
    private final String httpStatusVarName;
    private final String outputHeadersVarName;
    private final Notifier notifier;
    private Optional<RamlApiWrapper> ramlApi;

    public ApikitConfig(String name, String raml, List<FlowMapping> flowMappings, Supplier<Optional<IRaml>> apiSupplier, String httpStatusVarName, String outputHeadersVarName, Notifier notifier) {
        this.name = name;
        this.raml = raml;
        this.flowMappings = flowMappings;
        this.apiSupplier = apiSupplier;
        this.httpStatusVarName = httpStatusVarName;
        this.outputHeadersVarName = outputHeadersVarName;
        this.notifier = notifier;
    }

    public String getName() {
        return this.name;
    }

    public String getRaml() {
        return this.raml;
    }

    public List<FlowMapping> getFlowMappings() {
        return this.flowMappings;
    }

    public Optional<RamlApiWrapper> getApi() {
        if (this.ramlApi == null) {
            this.ramlApi = this.apiSupplier.get().map(api -> new RamlApiWrapper((IRaml)api, this.notifier));
        }
        return this.ramlApi;
    }

    public String getHttpStatusVarName() {
        return this.httpStatusVarName;
    }

    public String getOutputHeadersVarName() {
        return this.outputHeadersVarName;
    }
}

