/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.metadata.raml;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.mule.module.apikit.metadata.FlowMetadata;
import org.mule.module.apikit.metadata.interfaces.MetadataSource;
import org.mule.module.apikit.metadata.interfaces.Notifier;
import org.mule.module.apikit.metadata.model.RamlCoordinate;
import org.mule.raml.interfaces.model.IAction;
import org.mule.raml.interfaces.model.IRaml;
import org.mule.raml.interfaces.model.IResource;
import org.mule.raml.interfaces.model.parameter.IParameter;

public class RamlApiWrapper {
    private final Map<String, IResource> ramlResources = new HashMap<String, IResource>();
    private final Map<String, IParameter> baseUriParameters;
    private final Map<String, String> consolidatedSchemas;
    private final Notifier notifier;

    public RamlApiWrapper(IRaml ramlApi, Notifier notifier) {
        this.collectResources(ramlApi.getResources());
        this.consolidatedSchemas = ramlApi.getConsolidatedSchemas();
        this.baseUriParameters = ramlApi.getBaseUriParameters();
        this.notifier = notifier;
    }

    private void collectResources(Map<String, IResource> resources) {
        resources.values().forEach(resource -> {
            this.ramlResources.put(resource.getUri(), (IResource)resource);
            this.collectResources(resource.getResources());
        });
    }

    public Optional<MetadataSource> getActionForFlow(RamlApiWrapper api, RamlCoordinate coordinate, String httpStatusVar, String outboundHeadersVar) {
        return Optional.ofNullable(this.ramlResources.get(coordinate.getResource())).map(resource -> resource.getAction(coordinate.getMethod())).map(action -> new FlowMetadata(api, (IAction)action, coordinate, this.baseUriParameters, httpStatusVar, outboundHeadersVar, this.notifier));
    }

    public Map<String, String> getConsolidatedSchemas() {
        return this.consolidatedSchemas;
    }
}

