/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.metadata.model;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.mule.metadata.api.model.MetadataType;
import org.mule.module.apikit.metadata.MetadataFactory;
import org.mule.module.apikit.metadata.raml.RamlApiWrapper;
import org.mule.raml.interfaces.model.IMimeType;
import org.mule.raml.interfaces.model.parameter.IParameter;

public class Payload {
    private static final String MIME_APPLICATION_JSON = "application/json";
    private static final String MIME_APPLICATION_XML = "application/xml";
    private static final String MIME_MULTIPART_FORM_DATA = "multipart/form-data";
    private static final String MIME_APPLICATION_URL_ENCODED = "application/x-www-form-urlencoded";

    private Payload() {
    }

    public static MetadataType metadata(RamlApiWrapper api, @Nullable IMimeType body) {
        if (body == null) {
            return MetadataFactory.defaultMetadata();
        }
        String type = body.getType();
        String schema = Payload.resolveSchema(api, body);
        String example = body.getExample();
        switch (type) {
            case "application/json": {
                return Payload.applicationJsonMetadata(schema, example);
            }
            case "application/xml": {
                return Payload.applicationXmlMetadata(schema, example);
            }
            case "application/x-www-form-urlencoded": {
                return Payload.formMetadata(body.getFormParameters());
            }
            case "multipart/form-data": {
                return Payload.formMetadata(body.getFormParameters());
            }
        }
        return MetadataFactory.defaultMetadata();
    }

    private static String resolveSchema(RamlApiWrapper api, IMimeType body) {
        String schema = body.getSchema();
        if (api.getConsolidatedSchemas().containsKey(schema)) {
            schema = api.getConsolidatedSchemas().get(schema);
        }
        return schema;
    }

    private static MetadataType formMetadata(Map<String, List<IParameter>> formParameters) {
        return MetadataFactory.fromFormMetadata(formParameters);
    }

    private static MetadataType applicationXmlMetadata(String schema, String example) {
        if (schema != null) {
            return MetadataFactory.fromXSDSchema(schema, example);
        }
        if (example != null) {
            return MetadataFactory.fromXMLExample(example);
        }
        return MetadataFactory.defaultMetadata();
    }

    private static MetadataType applicationJsonMetadata(String schema, String example) {
        if (schema != null) {
            return MetadataFactory.fromJsonSchema(schema);
        }
        if (example != null) {
            return MetadataFactory.fromJsonExample(example);
        }
        return MetadataFactory.defaultMetadata();
    }
}

