/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.metadata.raml;

import java.util.Optional;
import java.util.Set;
import org.mule.apikit.common.FlowName;
import org.mule.module.apikit.metadata.model.FlowMapping;
import org.mule.module.apikit.metadata.model.RamlCoordinate;

public class RamlCoordsSimpleFactory {
    private Set<String> apiConfigNames;

    public RamlCoordsSimpleFactory(Set<String> apiConfigNames) {
        this.apiConfigNames = apiConfigNames;
    }

    public Optional<RamlCoordinate> createFromFlowName(String flowName) {
        String[] parts = FlowName.decode((String)flowName).split(":");
        if (parts.length < 2 || parts.length > 4) {
            return Optional.empty();
        }
        Builder builder = Builder.create(flowName, parts[0], parts[1]);
        if (parts.length == 3) {
            if (this.apiConfigNames.contains(parts[2])) {
                builder.configName(parts[2]);
            } else {
                builder.mediaType(parts[2]);
            }
        } else if (parts.length == 4) {
            builder.mediaType(parts[2]).configName(parts[3]);
        }
        RamlCoordinate coord = builder.build();
        if (coord.getConfigName() != null && !this.apiConfigNames.contains(coord.getConfigName())) {
            return Optional.empty();
        }
        if (this.apiConfigNames.size() > 1 && coord.getConfigName() == null) {
            return Optional.empty();
        }
        return Optional.of(coord);
    }

    public RamlCoordinate createFromFlowMapping(FlowMapping mapping) {
        String flowName = mapping.getFlowRef();
        String configName = mapping.getConfigName();
        String action = mapping.getAction();
        String resource = mapping.getResource();
        String contentType = mapping.getContentType();
        return new RamlCoordinate(flowName, action, resource, contentType, configName);
    }

    private static class Builder {
        private final String flowName;
        private final String methodName;
        private final String resourceName;
        private String mediaType = null;
        private String configName = null;

        private Builder(String flowName, String methodName, String resourceName) {
            this.flowName = flowName;
            this.methodName = methodName;
            this.resourceName = resourceName;
        }

        static Builder create(String key, String methodName, String resourceName) {
            return new Builder(key, methodName, resourceName);
        }

        Builder mediaType(String value) {
            this.mediaType = value;
            return this;
        }

        Builder configName(String value) {
            this.configName = value;
            return this;
        }

        private RamlCoordinate build() {
            return new RamlCoordinate(this.flowName, this.methodName, this.resourceName, this.mediaType, this.configName);
        }
    }
}

