/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.metadata;

import java.util.Optional;
import org.mule.metadata.api.model.FunctionType;
import org.mule.module.apikit.metadata.ApplicationModelWrapper;
import org.mule.module.apikit.metadata.MetadataHandler;
import org.mule.module.apikit.metadata.interfaces.Notifier;
import org.mule.module.apikit.metadata.interfaces.ResourceLoader;
import org.mule.module.apikit.metadata.raml.RamlHandler;
import org.mule.runtime.config.internal.model.ApplicationModel;

public class Metadata {
    private MetadataHandler metadataHandler;

    private Metadata(ApplicationModel applicationModel, ResourceLoader resourceLoader, Notifier notifier) {
        this.init(applicationModel, resourceLoader, notifier);
    }

    private void init(ApplicationModel applicationModel, ResourceLoader resourceLoader, Notifier notifier) {
        RamlHandler ramlHandler = new RamlHandler(resourceLoader, notifier);
        ApplicationModelWrapper wrapper = new ApplicationModelWrapper(applicationModel, ramlHandler, notifier);
        this.metadataHandler = new MetadataHandler(wrapper, notifier);
    }

    public Optional<FunctionType> getMetadataForFlow(String flowName) {
        return this.metadataHandler.getMetadataForFlow(flowName);
    }

    public static class Builder {
        private ResourceLoader resourceLoader;
        private ApplicationModel applicationModel;
        private Notifier notifier;

        public Builder withResourceLoader(ResourceLoader resourceLoader) {
            this.resourceLoader = resourceLoader;
            return this;
        }

        public Builder withApplicationModel(ApplicationModel applicationModel) {
            this.applicationModel = applicationModel;
            return this;
        }

        public Builder withNotifier(Notifier notifier) {
            this.notifier = notifier;
            return this;
        }

        public Metadata build() {
            return new Metadata(this.applicationModel, this.resourceLoader, this.notifier);
        }
    }
}

