/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.metadata;

import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.mule.metadata.api.model.FunctionType;
import org.mule.module.apikit.metadata.ApplicationModelWrapper;
import org.mule.module.apikit.metadata.interfaces.MetadataSource;
import org.mule.module.apikit.metadata.interfaces.Notifier;
import org.mule.module.apikit.metadata.model.ApikitConfig;
import org.mule.module.apikit.metadata.model.RamlCoordinate;
import org.mule.module.apikit.metadata.raml.RamlApiWrapper;

public class MetadataHandler {
    private ApplicationModelWrapper modelWrapper;
    private Notifier notifier;
    private Map<String, String> httpStatus;
    private Map<String, String> outboundHeaders;

    public MetadataHandler(ApplicationModelWrapper modelWrapper, Notifier notifier) {
        this.modelWrapper = modelWrapper;
        this.notifier = notifier;
        this.httpStatus = MetadataHandler.loadHttpStatusVars(modelWrapper);
        this.outboundHeaders = MetadataHandler.loadOutboundHeaders(modelWrapper);
    }

    private static Map<String, String> loadOutboundHeaders(ApplicationModelWrapper modelWrapper) {
        HashMap<String, String> outboundHeaders = new HashMap<String, String>();
        modelWrapper.getConfigurations().forEach(c -> outboundHeaders.put(c.getName(), c.getOutputHeadersVarName()));
        return outboundHeaders;
    }

    private static Map<String, String> loadHttpStatusVars(ApplicationModelWrapper modelWrapper) {
        HashMap<String, String> httpStatusVars = new HashMap<String, String>();
        modelWrapper.getConfigurations().forEach(c -> httpStatusVars.put(c.getName(), c.getHttpStatusVarName()));
        return httpStatusVars;
    }

    public Optional<FunctionType> getMetadataForFlow(String flowName) {
        Optional<RamlCoordinate> coordinate = this.modelWrapper.getRamlCoordinatesForFlow(flowName);
        if (!coordinate.isPresent()) {
            return Optional.empty();
        }
        Optional<ApikitConfig> config = this.modelWrapper.getConfig(coordinate.get().getConfigName());
        if (!config.isPresent()) {
            return Optional.empty();
        }
        String httpStatusVar = this.httpStatus.get(config.get().getName());
        String outboundHeadersVar = this.outboundHeaders.get(config.get().getName());
        if (Strings.isNullOrEmpty((String)httpStatusVar) || Strings.isNullOrEmpty((String)outboundHeadersVar)) {
            return Optional.empty();
        }
        return config.flatMap(ApikitConfig::getApi).flatMap(api -> api.getActionForFlow((RamlApiWrapper)api, (RamlCoordinate)coordinate.get(), httpStatusVar, outboundHeadersVar)).flatMap(MetadataSource::getMetadata);
    }
}

