/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.metadata.raml;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.mule.module.apikit.metadata.interfaces.Notifier;
import org.mule.module.apikit.metadata.interfaces.Parseable;
import org.mule.module.apikit.metadata.interfaces.ResourceLoader;
import org.mule.module.apikit.metadata.raml.RamlV1Parser;
import org.mule.module.apikit.metadata.raml.RamlV2Parser;
import org.mule.raml.interfaces.model.IRaml;

public class RamlHandler {
    private static final String PARSER_V2_PROPERTY = "apikit.raml.parser.v2";
    private final ResourceLoader resourceLoader;
    private final Notifier notifier;

    public RamlHandler(ResourceLoader resourceLoader, Notifier notifier) {
        this.resourceLoader = resourceLoader;
        this.notifier = notifier;
    }

    public Optional<IRaml> getRamlApi(String uri) {
        try {
            File resource = this.resourceLoader.getRamlResource(uri);
            if (resource == null) {
                this.notifier.error(String.format("RAML document '%s' not found.", uri));
                return Optional.empty();
            }
            String content = this.getRamlContent(resource);
            Parseable parser = this.getParser(content);
            return Optional.of(parser.build(resource, content));
        }
        catch (IOException e) {
            this.notifier.error(String.format("Error reading RAML document '%s'. Detail: %s", uri, e.getMessage()));
            return Optional.empty();
        }
    }

    private Parseable getParser(String ramlContent) {
        return RamlHandler.useParserV2(ramlContent) ? new RamlV2Parser() : new RamlV1Parser();
    }

    private String getRamlContent(File uri) throws IOException {
        try (FileInputStream is = new FileInputStream(uri);){
            String string = IOUtils.toString((InputStream)is);
            return string;
        }
    }

    private static boolean useParserV2(String content) {
        return Boolean.getBoolean(PARSER_V2_PROPERTY) || content.startsWith("#%RAML 1.0");
    }
}

