/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.metadata;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.mule.apikit.common.CollectionUtils;
import org.mule.module.apikit.metadata.ApikitElementIdentifiers;
import org.mule.module.apikit.metadata.interfaces.Notifier;
import org.mule.module.apikit.metadata.model.ApikitConfig;
import org.mule.module.apikit.metadata.model.Flow;
import org.mule.module.apikit.metadata.model.FlowMapping;
import org.mule.module.apikit.metadata.model.RamlCoordinate;
import org.mule.module.apikit.metadata.raml.RamlCoordsSimpleFactory;
import org.mule.module.apikit.metadata.raml.RamlHandler;
import org.mule.raml.interfaces.model.IRaml;
import org.mule.runtime.config.internal.model.ApplicationModel;
import org.mule.runtime.config.internal.model.ComponentModel;

public class ApplicationModelWrapper {
    private static final String PARAMETER_NAME = "name";
    private static final String PARAMETER_RAML = "raml";
    private static final String PARAMETER_OUTPUT_HEADERS_VAR = "outboundHeadersMapName";
    private static final String PARAMETER_HTTP_STATUS_VAR = "httpStatusVarName";
    private static final String PARAMETER_RESOURCE = "resource";
    private static final String PARAMETER_ACTION = "action";
    private static final String PARAMETER_CONTENT_TYPE = "content-type";
    private static final String PARAMETER_FLOW_REF = "flow-ref";
    private ApplicationModel applicationModel;
    private RamlHandler ramlHandler;
    private Notifier notifier;
    private Map<String, ApikitConfig> configMap;
    private Map<String, RamlCoordinate> metadataFlows;

    public ApplicationModelWrapper(ApplicationModel applicationModel, RamlHandler ramlHandler, Notifier notifier) {
        this.applicationModel = applicationModel;
        this.ramlHandler = ramlHandler;
        this.notifier = notifier;
        this.initialize();
    }

    private void initialize() {
        this.loadConfigs();
        this.loadFlows();
    }

    private void loadFlows() {
        List<Flow> flows = this.findFlows();
        RamlCoordsSimpleFactory coordsFactory = new RamlCoordsSimpleFactory(this.getConfigNames());
        Map<String, RamlCoordinate> conventionCoordinates = this.createCoordinatesForConventionFlows(flows, coordsFactory);
        Map<String, RamlCoordinate> flowMappingCoordinates = this.createCoordinatesForMappingFlows(flows, coordsFactory);
        this.metadataFlows = CollectionUtils.merge(Arrays.asList(conventionCoordinates, flowMappingCoordinates));
    }

    private void loadConfigs() {
        this.configMap = this.applicationModel.getRootComponentModel().getInnerComponents().stream().filter(ApikitElementIdentifiers::isApikitConfig).map(this::createApikitConfig).collect(Collectors.toMap(ApikitConfig::getName, Function.identity()));
    }

    private Set<String> getConfigNames() {
        return this.configMap.keySet();
    }

    public Collection<ApikitConfig> getConfigurations() {
        return this.configMap.values();
    }

    private Map<String, RamlCoordinate> createCoordinatesForMappingFlows(List<Flow> flows, RamlCoordsSimpleFactory coordsFactory) {
        Set flowNames = flows.stream().map(Flow::getName).collect(Collectors.toSet());
        return this.configMap.values().stream().flatMap(config -> config.getFlowMappings().stream()).filter(mapping -> flowNames.contains(mapping.getFlowRef())).map(coordsFactory::createFromFlowMapping).collect(Collectors.toMap(RamlCoordinate::getFlowName, Function.identity()));
    }

    private Map<String, RamlCoordinate> createCoordinatesForConventionFlows(List<Flow> flows, RamlCoordsSimpleFactory coordsFactory) {
        return flows.stream().map(flow -> coordsFactory.createFromFlowName(flow.getName())).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toMap(RamlCoordinate::getFlowName, Function.identity()));
    }

    private ApikitConfig createApikitConfig(ComponentModel unwrappedApikitConfig) {
        Map parameters = unwrappedApikitConfig.getParameters();
        String configName = (String)parameters.get(PARAMETER_NAME);
        String configRaml = (String)parameters.get(PARAMETER_RAML);
        String outputHeadersVarName = (String)parameters.get(PARAMETER_OUTPUT_HEADERS_VAR);
        String httpStatusVarName = (String)parameters.get(PARAMETER_HTTP_STATUS_VAR);
        List<FlowMapping> flowMappings = unwrappedApikitConfig.getInnerComponents().stream().filter(config -> ApikitElementIdentifiers.isFlowMappings(config.getIdentifier())).flatMap(flowMappingsElement -> flowMappingsElement.getInnerComponents().stream()).filter(flowMapping -> ApikitElementIdentifiers.isFlowMapping(flowMapping.getIdentifier())).map(unwrappedFlowMapping -> this.createFlowMapping(configName, (ComponentModel)unwrappedFlowMapping)).collect(Collectors.toList());
        RamlHandlerSupplier ramlSupplier = RamlHandlerSupplier.create(configRaml, this.ramlHandler);
        return new ApikitConfig(configName, configRaml, flowMappings, ramlSupplier, httpStatusVarName, outputHeadersVarName, this.notifier);
    }

    private FlowMapping createFlowMapping(String configName, ComponentModel unwrappedFlowMapping) {
        Map flowMappingParameters = unwrappedFlowMapping.getParameters();
        String resource = (String)flowMappingParameters.get(PARAMETER_RESOURCE);
        String action = (String)flowMappingParameters.get(PARAMETER_ACTION);
        String contentType = (String)flowMappingParameters.get(PARAMETER_CONTENT_TYPE);
        String flowRef = (String)flowMappingParameters.get(PARAMETER_FLOW_REF);
        return new FlowMapping(configName, resource, action, contentType, flowRef);
    }

    public List<Flow> findFlows() {
        return this.applicationModel.getRootComponentModel().getInnerComponents().stream().filter(ApikitElementIdentifiers::isFlow).map(this::createFlow).collect(Collectors.toList());
    }

    private Flow createFlow(ComponentModel componentModel) {
        Map parameters = componentModel.getParameters();
        String flowName = (String)parameters.get(PARAMETER_NAME);
        return new Flow(flowName);
    }

    public Optional<RamlCoordinate> getRamlCoordinatesForFlow(String flowName) {
        return Optional.ofNullable(this.metadataFlows.get(flowName));
    }

    public Optional<ApikitConfig> getConfig(String configName) {
        if (this.configMap.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.configMap.getOrDefault(configName, this.configMap.values().iterator().next()));
    }

    private static class RamlHandlerSupplier
    implements Supplier<Optional<IRaml>> {
        private String configRaml;
        private RamlHandler handler;

        private RamlHandlerSupplier(String configRaml, RamlHandler handler) {
            this.configRaml = configRaml;
            this.handler = handler;
        }

        private static RamlHandlerSupplier create(String configRaml, RamlHandler handler) {
            return new RamlHandlerSupplier(configRaml, handler);
        }

        @Override
        public Optional<IRaml> get() {
            return this.handler.getRamlApi(this.configRaml);
        }
    }
}

