/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.misc;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.mule.weave.v2.module.reader.SourceProvider;
import org.mule.weave.v2.module.reader.StringSourceProvider;
import org.mule.weave.v2.runtime.utils.WeaveSimpleRunner;
import org.yaml.snakeyaml.Yaml;

public class ExampleUtils {
    private static final String DW_INPUT_TYPE = "payload";
    private static final String DW_OUTPUT_TYPE = "application/dw";
    private static final String APPLICATION_XML_CONTENT_TYPE = "application/xml";
    private static final String DEFAULT_CONTENT_TYPE = "application/json";

    private ExampleUtils() {
    }

    public static String getExampleContentType(String example) {
        if (ExampleUtils.isValidXML(example)) {
            return APPLICATION_XML_CONTENT_TYPE;
        }
        return DEFAULT_CONTENT_TYPE;
    }

    public static String getExampleAsJSONIfNeeded(String payload) {
        if (!ExampleUtils.isValidXML(payload) && !ExampleUtils.isValidJSON(payload)) {
            return ExampleUtils.transformYamlExampleIntoJSON(payload);
        }
        return payload;
    }

    public static String getDataWeaveExpressionText(String example) {
        String transformContentType = ExampleUtils.getExampleContentType(example);
        example = ExampleUtils.getExampleAsJSONIfNeeded(example);
        WeaveSimpleRunner runner = new WeaveSimpleRunner();
        runner.addInput(DW_INPUT_TYPE, transformContentType, (SourceProvider)new StringSourceProvider(example));
        runner.setOutputType(DW_OUTPUT_TYPE);
        String weaveResult = runner.execute(DW_INPUT_TYPE).toString();
        return "%dw 2.0\noutput " + transformContentType + "\n---\n" + weaveResult + "\n";
    }

    private static String transformYamlExampleIntoJSON(String example) {
        Yaml yaml = new Yaml();
        Object yamlObject = yaml.load(example);
        try {
            return new ObjectMapper().writeValueAsString(yamlObject);
        }
        catch (JsonProcessingException e) {
            return "null";
        }
    }

    public static boolean isValidXML(String payload) {
        return payload.startsWith("<");
    }

    public static boolean isValidJSON(String payload) {
        try {
            new ObjectMapper().readTree(payload);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }
}

