/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.output.scopes;

import org.jdom2.CDATA;
import org.jdom2.Content;
import org.jdom2.Element;
import org.mule.tools.apikit.misc.ExampleUtils;
import org.mule.tools.apikit.output.GenerationModel;
import org.mule.tools.apikit.output.MuleConfigGenerator;
import org.mule.tools.apikit.output.scopes.Scope;

public class APIKitFlowScope
implements Scope {
    private final Element flow = new Element("flow", MuleConfigGenerator.XMLNS_NAMESPACE.getNamespace());
    private static final String LOGGER_ATTRIBUTE_LEVEL = "level";
    private static final String LOGGER_ATTRIBUTE_MESSAGE = "message";
    private static final String LOGGER_ATTRIBUTE_LEVEL_VALUE = "INFO";

    public APIKitFlowScope(GenerationModel flowEntry) {
        this.flow.setAttribute("name", flowEntry.getFlowName());
        if (flowEntry.getExampleWrapper() == null) {
            Element logger = new Element("logger", MuleConfigGenerator.XMLNS_NAMESPACE.getNamespace());
            logger.setAttribute(LOGGER_ATTRIBUTE_LEVEL, LOGGER_ATTRIBUTE_LEVEL_VALUE);
            logger.setAttribute(LOGGER_ATTRIBUTE_MESSAGE, this.flow.getAttribute("name").getValue());
            this.flow.addContent((Content)logger);
        } else {
            Element transform = new Element("transform", MuleConfigGenerator.EE_NAMESPACE.getNamespace());
            Element setPayload = new Element("set-payload", MuleConfigGenerator.EE_NAMESPACE.getNamespace());
            Element message = new Element(LOGGER_ATTRIBUTE_MESSAGE, MuleConfigGenerator.EE_NAMESPACE.getNamespace());
            CDATA cdataSection = new CDATA(this.generateTransformTextForExample(flowEntry.getExampleWrapper().trim()));
            setPayload.addContent((Content)cdataSection);
            message.setContent((Content)setPayload);
            transform.addNamespaceDeclaration(MuleConfigGenerator.EE_NAMESPACE.getNamespace());
            transform.setAttribute("schemaLocation", MuleConfigGenerator.EE_NAMESPACE.getNamespace().getURI() + " " + MuleConfigGenerator.EE_NAMESPACE.getLocation(), MuleConfigGenerator.XSI_NAMESPACE.getNamespace());
            transform.addContent((Content)message);
            this.flow.addContent((Content)transform);
        }
    }

    private String generateTransformTextForExample(String example) {
        return ExampleUtils.getDataWeaveExpressionText(example);
    }

    @Override
    public Element generate() {
        return this.flow;
    }
}

