/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.model;

import java.io.File;
import org.apache.commons.io.FilenameUtils;
import org.mule.tools.apikit.model.APIKitConfig;
import org.mule.tools.apikit.model.HttpListener4xConfig;

public class API {
    public static final String DEFAULT_HOST = "0.0.0.0";
    public static final int DEFAULT_PORT = 8081;
    public static final String DEFAULT_BASE_URI = "http://0.0.0.0:8081/api";
    public static final String DEFAULT_BASE_PATH = "/";
    public static final String DEFAULT_PROTOCOL = "HTTP";
    public static final String DEFAULT_CONSOLE_PATH = "/console/*";
    public static final String DEFAULT_CONSOLE_PATH_INBOUND = "http://0.0.0.0:8081/console";
    private APIKitConfig config;
    private HttpListener4xConfig httpListenerConfig;
    private String path;
    private String baseUri;
    private File xmlFile;
    private File ramlFile;
    private String id;

    public API(File ramlFile, File xmlFile, String baseUri, String path) {
        this.path = path;
        this.ramlFile = ramlFile;
        this.xmlFile = xmlFile;
        this.baseUri = baseUri;
        this.id = FilenameUtils.removeExtension((String)ramlFile.getName()).trim();
    }

    public API(File ramlFile, File xmlFile, String baseUri, String path, APIKitConfig config) {
        this(ramlFile, xmlFile, baseUri, path);
        this.config = config;
    }

    public File getXmlFile() {
        return this.xmlFile;
    }

    public void setXmlFile(File xmlFile) {
        this.xmlFile = xmlFile;
    }

    public File getXmlFile(File rootDirectory) {
        if (this.xmlFile == null) {
            this.xmlFile = new File(rootDirectory, FilenameUtils.getBaseName((String)this.ramlFile.getAbsolutePath()) + ".xml");
        }
        return this.xmlFile;
    }

    public File getRamlFile() {
        return this.ramlFile;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public HttpListener4xConfig getHttpListenerConfig() {
        return this.httpListenerConfig;
    }

    public APIKitConfig getConfig() {
        return this.config;
    }

    public void setConfig(APIKitConfig config) {
        this.config = config;
    }

    public void setHttpListenerConfig(HttpListener4xConfig httpListenerConfig) {
        this.httpListenerConfig = httpListenerConfig;
    }

    public void setDefaultAPIKitConfig() {
        this.config = new APIKitConfig();
        this.config.setRaml(this.ramlFile.getName());
        this.config.setName(this.id + "-" + "config");
    }

    public void setDefaultHttpListenerConfig() {
        String httpListenerConfigName = this.id == null ? "httpListenerConfig" : this.id + "-" + "httpListenerConfig";
        this.httpListenerConfig = new HttpListener4xConfig(httpListenerConfigName);
    }

    public String getBaseUri() {
        return this.baseUri;
    }

    public void setBaseUri(String baseUri) {
        this.baseUri = baseUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        API api = (API)o;
        return this.ramlFile.equals(api.ramlFile);
    }

    public int hashCode() {
        return this.ramlFile.hashCode();
    }

    public String getId() {
        return this.id;
    }
}

