/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.maven.plugin.logging.Log;
import org.mule.tools.apikit.input.MuleConfigParser;
import org.mule.tools.apikit.input.MuleDomainParser;
import org.mule.tools.apikit.input.RAMLFilesParser;
import org.mule.tools.apikit.misc.FileListUtils;
import org.mule.tools.apikit.model.APIFactory;
import org.mule.tools.apikit.model.RuntimeEdition;
import org.mule.tools.apikit.output.GenerationModel;
import org.mule.tools.apikit.output.GenerationStrategy;
import org.mule.tools.apikit.output.MuleArtifactJsonGenerator;
import org.mule.tools.apikit.output.MuleConfigGenerator;

public class Scaffolder {
    public static final String DEFAULT_MULE_VERSION = "4.0.0";
    public static final RuntimeEdition DEFAULT_RUNTIME_EDITION = RuntimeEdition.CE;
    private final MuleConfigGenerator muleConfigGenerator;
    private final MuleArtifactJsonGenerator muleArtifactJsonGenerator;

    public static Scaffolder createScaffolder(Log log, File muleXmlOutputDirectory, List<String> specFiles, List<String> muleXmlFiles) throws IOException {
        return Scaffolder.createScaffolder(log, muleXmlOutputDirectory, specFiles, muleXmlFiles, null, DEFAULT_MULE_VERSION, DEFAULT_RUNTIME_EDITION, null);
    }

    public static Scaffolder createScaffolder(Log log, File muleXmlOutputDirectory, List<String> specFiles, List<String> muleXmlFiles, String domainFile) throws IOException {
        return Scaffolder.createScaffolder(log, muleXmlOutputDirectory, specFiles, muleXmlFiles, domainFile, DEFAULT_MULE_VERSION, DEFAULT_RUNTIME_EDITION, null);
    }

    public static Scaffolder createScaffolder(Log log, File muleXmlOutputDirectory, List<String> specFiles, List<String> muleXmlFiles, String domainFile, String minMuleVersion, RuntimeEdition runtimeEdition) throws IOException {
        return Scaffolder.createScaffolder(log, muleXmlOutputDirectory, specFiles, muleXmlFiles, domainFile, minMuleVersion, runtimeEdition, null);
    }

    public static Scaffolder createScaffolder(Log log, File muleXmlOutputDirectory, List<String> specPaths, List<String> muleXmlPaths, String domainPath, String minMuleVersion, RuntimeEdition runtimeEdition, List<String> ramlsWithExtensionEnabledPaths) throws IOException {
        FileListUtils fileUtils = new FileListUtils(log);
        Map<File, InputStream> ramlStreams = fileUtils.toStreamsOrFail(specPaths);
        Map<File, InputStream> muleStreams = fileUtils.toStreamsOrFail(muleXmlPaths);
        TreeSet<File> ramlWithExtensionEnabled = new TreeSet<File>();
        if (ramlsWithExtensionEnabledPaths != null) {
            for (String ramlWithEE : ramlsWithExtensionEnabledPaths) {
                ramlWithExtensionEnabled.add(new File(ramlWithEE));
            }
        }
        InputStream domainStream = Scaffolder.getDomainStream(log, domainPath);
        return new Scaffolder(log, muleXmlOutputDirectory, ramlStreams, muleStreams, domainStream, ramlWithExtensionEnabled, minMuleVersion, runtimeEdition);
    }

    public Scaffolder(Log log, File muleXmlOutputDirectory, Map<File, InputStream> ramls, Map<File, InputStream> xmls, InputStream domainStream, Set<File> ramlsWithExtensionEnabled, String minMuleVersion, RuntimeEdition runtimeEdition) {
        MuleDomainParser muleDomainParser = new MuleDomainParser(log, domainStream);
        APIFactory apiFactory = new APIFactory(muleDomainParser.getHttpListenerConfigs());
        MuleConfigParser muleConfigParser = new MuleConfigParser(log, apiFactory).parse(ramls.keySet(), xmls);
        RAMLFilesParser RAMLFilesParser2 = new RAMLFilesParser(log, ramls, apiFactory);
        List<GenerationModel> generationModels = new GenerationStrategy(log).generate(RAMLFilesParser2, muleConfigParser);
        if (runtimeEdition == null) {
            runtimeEdition = DEFAULT_RUNTIME_EDITION;
        }
        if (minMuleVersion == null) {
            minMuleVersion = DEFAULT_MULE_VERSION;
        }
        this.muleConfigGenerator = new MuleConfigGenerator(log, muleXmlOutputDirectory, generationModels, muleDomainParser.getHttpListenerConfigs(), ramlsWithExtensionEnabled, minMuleVersion, runtimeEdition);
        this.muleArtifactJsonGenerator = new MuleArtifactJsonGenerator(log, this.getProjectBaseDirectory(muleXmlOutputDirectory), minMuleVersion);
    }

    private static InputStream getDomainStream(Log log, String domainPath) {
        FileInputStream domainStream = null;
        if (domainPath != null) {
            File domain = null;
            try {
                domain = new File(domainPath);
                domainStream = new FileInputStream(domain);
            }
            catch (FileNotFoundException e) {
                if (log != null) {
                    log.error((CharSequence)("Error opening file [" + domain + "] file"), (Throwable)e);
                }
                throw new RuntimeException(e);
            }
        }
        return domainStream;
    }

    private File getProjectBaseDirectory(File muleXmlOutputDirectory) {
        Path outputDirectory = muleXmlOutputDirectory.toPath();
        if (outputDirectory.endsWith("src/main/mule") || outputDirectory.endsWith("src/main/mule/")) {
            return outputDirectory.getParent().getParent().getParent().toFile();
        }
        return muleXmlOutputDirectory;
    }

    public void run() {
        this.muleConfigGenerator.generate();
        this.muleArtifactJsonGenerator.generate();
    }
}

