/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.input.parsers;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.filter.Filters;
import org.jdom2.xpath.XPathExpression;
import org.jdom2.xpath.XPathFactory;
import org.mule.tools.apikit.input.parsers.MuleConfigFileParser;
import org.mule.tools.apikit.misc.APIKitTools;
import org.mule.tools.apikit.model.APIKitConfig;

public class APIKitConfigParser
implements MuleConfigFileParser {
    @Override
    public Map<String, APIKitConfig> parse(Document document) {
        HashMap<String, APIKitConfig> apikitConfigs = new HashMap<String, APIKitConfig>();
        XPathExpression xp = XPathFactory.instance().compile("//*/*[local-name()='config']", Filters.element((Namespace)APIKitTools.API_KIT_NAMESPACE.getNamespace()));
        List elements = xp.evaluate((Object)document);
        for (Element element : elements) {
            Attribute name = element.getAttribute("name");
            Attribute raml = element.getAttribute("raml");
            Attribute extensionEnabled = element.getAttribute("extensionEnabled");
            Attribute outboundHeadersMapName = element.getAttribute("outboundHeadersMapName");
            Attribute httpStatusVarName = element.getAttribute("httpStatusVarName");
            if (raml == null) {
                throw new IllegalArgumentException("raml attribute is required");
            }
            APIKitConfig apiKitConfig = new APIKitConfig();
            apiKitConfig.setRaml(raml.getValue());
            if (name != null) {
                apiKitConfig.setName(name.getValue());
            }
            if (outboundHeadersMapName != null) {
                apiKitConfig.setOutboundHeadersMapName(outboundHeadersMapName.getValue());
            }
            if (extensionEnabled != null) {
                apiKitConfig.setExtensionEnabled(Boolean.valueOf(extensionEnabled.getValue()));
            }
            if (httpStatusVarName != null) {
                apiKitConfig.setHttpStatusVarName(httpStatusVarName.getValue());
            }
            String configId = apiKitConfig.getName() != null ? apiKitConfig.getName() : "noNameConfig";
            apikitConfigs.put(configId, apiKitConfig);
        }
        return apikitConfigs;
    }
}

