/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.model;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.mule.tools.apikit.model.API;
import org.mule.tools.apikit.model.APIKitConfig;
import org.mule.tools.apikit.model.HttpListener4xConfig;

public class APIFactory {
    private Map<File, API> apis = new HashMap<File, API>();
    private Map<String, HttpListener4xConfig> domainHttpListenerConfigs = new HashMap<String, HttpListener4xConfig>();

    public APIFactory(Map<String, HttpListener4xConfig> domainHttpListenerConfigs) {
        this.domainHttpListenerConfigs.putAll(domainHttpListenerConfigs);
    }

    public APIFactory() {
    }

    public API createAPIBindingInboundEndpoint(File ramlFile, File xmlFile, String baseUri, String path, APIKitConfig config) {
        return this.createAPIBinding(ramlFile, xmlFile, baseUri, path, config, null);
    }

    public API createAPIBinding(File ramlFile, File xmlFile, String baseUri, String path, APIKitConfig config, HttpListener4xConfig httpListenerConfig) {
        Validate.notNull((Object)ramlFile);
        if (this.apis.containsKey(ramlFile)) {
            API api = this.apis.get(ramlFile);
            if (api.getXmlFile() == null && xmlFile != null) {
                api.setXmlFile(xmlFile);
            }
            return api;
        }
        API api = new API(ramlFile, xmlFile, baseUri, path, config);
        if (httpListenerConfig == null) {
            if (this.domainHttpListenerConfigs.size() > 0) {
                api.setHttpListenerConfig(this.getFirstLC());
            } else {
                api.setDefaultHttpListenerConfig();
            }
        } else {
            api.setHttpListenerConfig(httpListenerConfig);
        }
        api.setConfig(config);
        this.apis.put(ramlFile, api);
        return api;
    }

    public Map<String, HttpListener4xConfig> getDomainHttpListenerConfigs() {
        return this.domainHttpListenerConfigs;
    }

    private HttpListener4xConfig getFirstLC() {
        ArrayList<Map.Entry<String, HttpListener4xConfig>> numericPortsList = new ArrayList<Map.Entry<String, HttpListener4xConfig>>();
        ArrayList<Map.Entry<String, HttpListener4xConfig>> nonNumericPortsList = new ArrayList<Map.Entry<String, HttpListener4xConfig>>();
        for (Map.Entry<String, HttpListener4xConfig> entry : this.domainHttpListenerConfigs.entrySet()) {
            if (StringUtils.isNumeric((String)entry.getValue().getPort())) {
                numericPortsList.add(entry);
                continue;
            }
            nonNumericPortsList.add(entry);
        }
        Collections.sort(numericPortsList, new Comparator<Map.Entry<String, HttpListener4xConfig>>(){

            @Override
            public int compare(Map.Entry<String, HttpListener4xConfig> o1, Map.Entry<String, HttpListener4xConfig> o2) {
                Integer i1 = Integer.parseInt(o1.getValue().getPort());
                Integer i2 = Integer.parseInt(o2.getValue().getPort());
                return i1.compareTo(i2);
            }
        });
        numericPortsList.addAll(nonNumericPortsList);
        return (HttpListener4xConfig)((Map.Entry)numericPortsList.get(0)).getValue();
    }
}

