/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.output.scopes;

import org.jdom2.CDATA;
import org.jdom2.Content;
import org.jdom2.Element;
import org.mule.tools.apikit.misc.ExampleUtils;
import org.mule.tools.apikit.output.GenerationModel;
import org.mule.tools.apikit.output.MuleConfigGenerator;
import org.mule.tools.apikit.output.scopes.Scope;

public class APIKitFlowScope
implements Scope {
    private final Element flow = new Element("flow", MuleConfigGenerator.XMLNS_NAMESPACE.getNamespace());
    private static final String LOGGER_ATTRIBUTE_LEVEL = "level";
    private static final String LOGGER_ATTRIBUTE_MESSAGE = "message";
    private static final String LOGGER_ATTRIBUTE_LEVEL_VALUE = "INFO";

    public APIKitFlowScope(GenerationModel flowEntry) {
        this(flowEntry, true);
    }

    public APIKitFlowScope(GenerationModel flowEntry, boolean isMuleEE) {
        this.flow.setAttribute("name", flowEntry.getFlowName());
        this.flow.addContent((Content)this.generateFlowContent(flowEntry, isMuleEE));
    }

    private Element generateFlowContent(GenerationModel flowEntry, boolean isMuleEE) {
        if (isMuleEE && flowEntry.getExampleWrapper() != null) {
            try {
                return this.generateTransform(flowEntry);
            }
            catch (Exception e) {
                return this.generateLogger(flowEntry.getFlowName());
            }
        }
        return this.generateLogger(flowEntry.getFlowName());
    }

    private Element generateTransform(GenerationModel flowEntry) {
        Element transform = new Element("transform", MuleConfigGenerator.EE_NAMESPACE.getNamespace());
        Element setPayload = new Element("set-payload", MuleConfigGenerator.EE_NAMESPACE.getNamespace());
        Element message = new Element(LOGGER_ATTRIBUTE_MESSAGE, MuleConfigGenerator.EE_NAMESPACE.getNamespace());
        CDATA cdataSection = new CDATA(this.generateTransformTextForExample(flowEntry.getExampleWrapper().trim()));
        setPayload.addContent((Content)cdataSection);
        message.setContent((Content)setPayload);
        transform.addNamespaceDeclaration(MuleConfigGenerator.EE_NAMESPACE.getNamespace());
        transform.setAttribute("schemaLocation", MuleConfigGenerator.EE_NAMESPACE.getNamespace().getURI() + " " + MuleConfigGenerator.EE_NAMESPACE.getLocation(), MuleConfigGenerator.XSI_NAMESPACE.getNamespace());
        transform.addContent((Content)message);
        return transform;
    }

    private Element generateLogger(String message) {
        Element logger = new Element("logger", MuleConfigGenerator.XMLNS_NAMESPACE.getNamespace());
        logger.setAttribute(LOGGER_ATTRIBUTE_LEVEL, LOGGER_ATTRIBUTE_LEVEL_VALUE);
        logger.setAttribute(LOGGER_ATTRIBUTE_MESSAGE, message);
        return logger;
    }

    private String generateTransformTextForExample(String example) {
        return ExampleUtils.getDataWeaveExpressionText(example);
    }

    @Override
    public Element generate() {
        return this.flow;
    }
}

