/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.input;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.logging.Log;
import org.mule.raml.implv1.ParserV1Utils;
import org.mule.raml.implv2.ParserV2Utils;
import org.mule.raml.interfaces.model.IAction;
import org.mule.raml.interfaces.model.IMimeType;
import org.mule.raml.interfaces.model.IRaml;
import org.mule.raml.interfaces.model.IResource;
import org.mule.tools.apikit.misc.APIKitTools;
import org.mule.tools.apikit.model.API;
import org.mule.tools.apikit.model.APIFactory;
import org.mule.tools.apikit.model.ResourceActionMimeTypeTriplet;
import org.mule.tools.apikit.output.GenerationModel;
import org.raml.v2.api.loader.CompositeResourceLoader;
import org.raml.v2.api.loader.DefaultResourceLoader;
import org.raml.v2.api.loader.FileResourceLoader;
import org.raml.v2.api.loader.ResourceLoader;
import org.raml.v2.api.loader.RootRamlFileResourceLoader;

public class RAMLFilesParser {
    private Map<ResourceActionMimeTypeTriplet, GenerationModel> entries = new HashMap<ResourceActionMimeTypeTriplet, GenerationModel>();
    private final APIFactory apiFactory;
    private final Log log;

    public RAMLFilesParser(Log log, Map<File, InputStream> fileStreams, APIFactory apiFactory) {
        this.log = log;
        this.apiFactory = apiFactory;
        ArrayList<File> processedFiles = new ArrayList<File>();
        for (Map.Entry<File, InputStream> fileInputStreamEntry : fileStreams.entrySet()) {
            String content;
            File ramlFile = fileInputStreamEntry.getKey();
            try {
                content = IOUtils.toString((InputStream)fileInputStreamEntry.getValue());
            }
            catch (IOException ioe) {
                this.log.info((CharSequence)("Error loading file " + ramlFile.getName()));
                break;
            }
            String rootRamlName = ramlFile.getName();
            String ramlFolderPath = null;
            File ramlFileParent = null;
            if (ramlFile.getParentFile() != null) {
                ramlFolderPath = ramlFile.getParentFile().getPath();
                ramlFileParent = ramlFile.getParentFile();
            }
            if (!this.isValidRaml(rootRamlName, content, ramlFolderPath)) continue;
            try {
                IRaml raml;
                if (ParserV2Utils.useParserV2((String)content)) {
                    CompositeResourceLoader resourceLoader = new CompositeResourceLoader(new ResourceLoader[]{new RootRamlFileResourceLoader(ramlFileParent), new DefaultResourceLoader(), new FileResourceLoader(ramlFolderPath)});
                    raml = ParserV2Utils.build((ResourceLoader)resourceLoader, (String)ramlFile.getPath(), (String)content);
                } else {
                    raml = ParserV1Utils.build((String)content, (String)ramlFolderPath, (String)rootRamlName);
                }
                this.collectResources(ramlFile, raml.getResources(), "http://0.0.0.0:8081/api");
                processedFiles.add(ramlFile);
            }
            catch (Exception e) {
                log.info((CharSequence)("Could not parse [" + ramlFile + "] as root RAML file. Reason: " + e.getMessage()));
                log.debug((Throwable)e);
            }
        }
        if (processedFiles.size() > 0) {
            this.log.info((CharSequence)("The following RAML files were parsed correctly: " + processedFiles));
        } else {
            this.log.error((CharSequence)"RAML Root not found. None of the files were recognized as valid root RAML files.");
        }
    }

    private boolean isValidRaml(String fileName, String content, String filePath) {
        List errors;
        if (ParserV2Utils.useParserV2((String)content)) {
            CompositeResourceLoader resourceLoader = new CompositeResourceLoader(new ResourceLoader[]{new RootRamlFileResourceLoader(new File(filePath)), new DefaultResourceLoader(), new FileResourceLoader(filePath)});
            errors = ParserV2Utils.validate((ResourceLoader)resourceLoader, (String)fileName, (String)content);
        } else {
            errors = ParserV1Utils.validate((String)filePath, (String)fileName, (String)content);
        }
        if (!errors.isEmpty()) {
            if (errors.size() == 1 && ((String)errors.get(0)).toLowerCase().contains("root")) {
                this.log.info((CharSequence)("File '" + fileName + "' is not a root RAML file."));
            } else {
                this.log.info((CharSequence)("File '" + fileName + "' is not a valid root RAML file. It contains some errors/warnings. See below: "));
                int problemCount = 0;
                for (String error : errors) {
                    this.log.info((CharSequence)("ERROR " + ++problemCount + ": " + error));
                }
            }
            return false;
        }
        this.log.info((CharSequence)("File '" + fileName + "' is a VALID root RAML file."));
        return true;
    }

    void collectResources(File filename, Map<String, IResource> resourceMap, String baseUri) {
        for (IResource resource : resourceMap.values()) {
            for (IAction action : resource.getActions().values()) {
                API api = this.apiFactory.createAPIBinding(filename, null, baseUri, APIKitTools.getPathFromUri(baseUri, false), null, null);
                Map mimeTypes = action.getBody();
                boolean addGenericAction = false;
                if (mimeTypes != null && !mimeTypes.isEmpty()) {
                    for (IMimeType mimeType : mimeTypes.values()) {
                        if (mimeType.getSchema() != null || mimeType.getFormParameters() != null && !mimeType.getFormParameters().isEmpty()) {
                            this.addResource(api, resource, action, mimeType.getType());
                            continue;
                        }
                        addGenericAction = true;
                    }
                } else {
                    addGenericAction = true;
                }
                if (!addGenericAction) continue;
                this.addResource(api, resource, action, null);
            }
            this.collectResources(filename, resource.getResources(), baseUri);
        }
    }

    void addResource(API api, IResource resource, IAction action, String mimeType) {
        String completePath = APIKitTools.getCompletePathFromBasePathAndPath(api.getHttpListenerConfig().getBasePath(), api.getPath());
        ResourceActionMimeTypeTriplet resourceActionTriplet = new ResourceActionMimeTypeTriplet(api, completePath + resource.getUri(), action.getType().toString(), mimeType);
        this.entries.put(resourceActionTriplet, new GenerationModel(api, resource, action, mimeType));
    }

    public Map<ResourceActionMimeTypeTriplet, GenerationModel> getEntries() {
        return this.entries;
    }
}

