/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.misc;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.mule.weave.v2.runtime.DataWeaveResult;
import org.mule.weave.v2.runtime.DataWeaveScriptingEngine;
import org.mule.weave.v2.runtime.ScriptingBindings;
import org.yaml.snakeyaml.Yaml;

public class ExampleUtils {
    private static final String APPLICATION_XML_CONTENT_TYPE = "application/xml";
    private static final String DEFAULT_CONTENT_TYPE = "application/json";

    private ExampleUtils() {
    }

    public static String getExampleContentType(String example) {
        if (ExampleUtils.isValidXML(example)) {
            return APPLICATION_XML_CONTENT_TYPE;
        }
        return DEFAULT_CONTENT_TYPE;
    }

    public static String getExampleAsJSONIfNeeded(String payload) {
        if (!ExampleUtils.isValidXML(payload) && !ExampleUtils.isValidJSON(payload)) {
            return ExampleUtils.transformYamlExampleIntoJSON(payload);
        }
        return payload;
    }

    public static String getDataWeaveExpressionText(String example) {
        String transformContentType = ExampleUtils.getExampleContentType(example);
        example = ExampleUtils.getExampleAsJSONIfNeeded(example);
        String weaveResult = ExampleUtils.asDataWeave(example, transformContentType);
        return "%dw 2.0\noutput " + transformContentType + "\n---\n" + weaveResult + "\n";
    }

    private static String asDataWeave(String payload, String mimeType) {
        String script = "output application/dw --- payload";
        ScriptingBindings bindings = new ScriptingBindings().addBinding("payload", (Object)payload, mimeType);
        DataWeaveResult result = DataWeaveScriptingEngine.write((String)script, (ScriptingBindings)bindings);
        return result.getContentAsString();
    }

    private static String transformYamlExampleIntoJSON(String example) {
        Yaml yaml = new Yaml();
        Object yamlObject = yaml.load(example);
        try {
            return new ObjectMapper().disableDefaultTyping().writeValueAsString(yamlObject);
        }
        catch (JsonProcessingException e) {
            return "null";
        }
    }

    public static boolean isValidXML(String payload) {
        return payload.startsWith("<");
    }

    public static boolean isValidJSON(String payload) {
        try {
            new ObjectMapper().disableDefaultTyping().readTree(payload);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }
}

