/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.input.parsers;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.plugin.logging.Log;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.filter.Filters;
import org.jdom2.xpath.XPathExpression;
import org.jdom2.xpath.XPathFactory;
import org.mule.apikit.common.FlowName;
import org.mule.tools.apikit.input.APIKitFlow;
import org.mule.tools.apikit.input.parsers.MuleConfigFileParser;
import org.mule.tools.apikit.misc.APIKitTools;
import org.mule.tools.apikit.model.API;
import org.mule.tools.apikit.model.ResourceActionMimeTypeTriplet;
import org.mule.tools.apikit.output.MuleConfigGenerator;

public class APIKitFlowsParser
implements MuleConfigFileParser {
    private final Log log;
    private final Map<String, API> includedApis;

    public APIKitFlowsParser(Log log, Map<String, API> includedApis) {
        this.log = log;
        this.includedApis = includedApis;
    }

    @Override
    public Set<ResourceActionMimeTypeTriplet> parse(Document document) {
        HashSet<ResourceActionMimeTypeTriplet> entries = new HashSet<ResourceActionMimeTypeTriplet>();
        XPathExpression xp = XPathFactory.instance().compile("//*/*[local-name()='flow']", Filters.element((Namespace)MuleConfigGenerator.XMLNS_NAMESPACE.getNamespace()));
        List elements = xp.evaluate((Object)document);
        for (Element element : elements) {
            APIKitFlow flow;
            String name = FlowName.decode((String)element.getAttributeValue("name"));
            try {
                flow = APIKitFlow.buildFromName(name, this.includedApis.keySet());
            }
            catch (IllegalArgumentException iae) {
                this.log.info((CharSequence)("Flow named '" + name + "' is not an APIKit Flow because it does not follow APIKit naming convention."));
                continue;
            }
            API api = this.includedApis.get(flow.getConfigRef());
            String resource = flow.getResource();
            if (api != null) {
                if (!resource.startsWith("/")) {
                    resource = "/" + resource;
                }
                if (api.getPath() == null) {
                    throw new IllegalStateException("Api path is invalid");
                }
                String completePath = APIKitTools.getCompletePathFromBasePathAndPath(api.getHttpListenerConfig().getBasePath(), api.getPath());
                entries.add(new ResourceActionMimeTypeTriplet(api, completePath + resource, flow.getAction(), flow.getMimeType()));
                continue;
            }
            throw new IllegalStateException("No APIKit entries found in Mule config");
        }
        return entries;
    }
}

