/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.input.parsers;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.filter.Filters;
import org.jdom2.xpath.XPathExpression;
import org.jdom2.xpath.XPathFactory;
import org.mule.tools.apikit.input.parsers.MuleConfigFileParser;
import org.mule.tools.apikit.model.HttpListener4xConfig;
import org.mule.tools.apikit.model.HttpListenerConnection;
import org.mule.tools.apikit.output.MuleConfigGenerator;

public class HttpListener4xConfigParser
implements MuleConfigFileParser {
    public static final String ELEMENT_NAME = "listener-config";

    @Override
    public Map<String, HttpListener4xConfig> parse(Document document) {
        HashMap<String, HttpListener4xConfig> httpListenerConfigMap = new HashMap<String, HttpListener4xConfig>();
        XPathExpression xp = XPathFactory.instance().compile("//*/*[local-name()='listener-config']", Filters.element((Namespace)MuleConfigGenerator.HTTP_NAMESPACE.getNamespace()));
        List elements = xp.evaluate((Object)document);
        for (Element element : elements) {
            String name = element.getAttributeValue("name");
            if (name == null) {
                throw new IllegalStateException("Cannot retrieve name.");
            }
            String basePath = element.getAttributeValue("basePath");
            if (basePath == null) {
                basePath = "/";
            } else if (!basePath.startsWith("/")) {
                basePath = "/" + basePath;
            }
            for (Element child : element.getChildren()) {
                String protocol;
                if (!child.getName().equals("listener-connection")) continue;
                String host = child.getAttributeValue("host");
                if (host == null) {
                    throw new IllegalStateException("Cannot retrieve host.");
                }
                String port = child.getAttributeValue("port");
                if (port == null) {
                    port = Integer.toString(8081);
                }
                if ((protocol = child.getAttributeValue("protocol")) == null) {
                    protocol = "HTTP";
                }
                httpListenerConfigMap.put(name, new HttpListener4xConfig(name, basePath, new HttpListenerConnection(host, port, protocol)));
            }
        }
        return httpListenerConfigMap;
    }
}

