/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.misc;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.logging.Log;

public class FileListUtils {
    private final Log log;

    public FileListUtils(Log log) {
        this.log = log;
    }

    public FileListUtils() {
        this.log = null;
    }

    public Map<File, InputStream> toStreamsOrFail(List<String> absolutePaths) throws IOException {
        Map<File, InputStream> streams = this.toFiles(absolutePaths);
        if ((streams == null || streams.size() == 0) && absolutePaths.size() > 0) {
            throw new IOException("Error: None of the following files could be parsed: " + absolutePaths);
        }
        return streams;
    }

    public Map<File, InputStream> toFiles(List<String> absolutePaths) {
        HashMap<File, InputStream> fileStreams = new HashMap<File, InputStream>();
        for (String absolutePath : absolutePaths) {
            this.createFile(fileStreams, new File(absolutePath));
        }
        return fileStreams;
    }

    public Map<File, InputStream> toStreamFromFiles(List<File> files) {
        HashMap<File, InputStream> fileStreams = new HashMap<File, InputStream>();
        for (File file : files) {
            this.createFile(fileStreams, file);
        }
        return fileStreams;
    }

    void createFile(Map<File, InputStream> fileStreams, File file) {
        try {
            File absoluteFile = file.getAbsoluteFile();
            fileStreams.put(absoluteFile, new FileInputStream(absoluteFile));
        }
        catch (FileNotFoundException e) {
            if (this.log != null) {
                this.log.error((CharSequence)("Error opening file [" + file + "]"), (Throwable)e);
            }
            throw new RuntimeException(e);
        }
    }

    public static List<Path> listFiles(String baseDir, String dir) {
        final ArrayList<Path> files = new ArrayList<Path>();
        Path path = Paths.get(baseDir, dir);
        try {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (!attrs.isDirectory()) {
                        files.add(file);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            return files;
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
    }
}

