/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.output;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.logging.Log;
import org.json.JSONException;
import org.json.JSONObject;

public class MuleArtifactJsonGenerator {
    private final File rootDirectory;
    private final String minMuleVersion;
    private final Log log;
    private static final String MULE_ARTIFACT_FILENAME = "mule-artifact.json";
    private static final String MIN_MULE_VERSION = "minMuleVersion";

    public MuleArtifactJsonGenerator(Log log, File rootDirectory, String minMuleVersion) {
        this.log = log;
        this.rootDirectory = rootDirectory;
        this.minMuleVersion = minMuleVersion;
    }

    public void generate() {
        try {
            this.save(this.generateArtifact());
        }
        catch (Exception e) {
            this.log.error((CharSequence)"Error generating descriptor mule-artifact.json", (Throwable)e);
        }
    }

    private void save(String artifactJson) throws IOException {
        Files.write(Paths.get(this.rootDirectory.getPath(), MULE_ARTIFACT_FILENAME), artifactJson.getBytes(), new OpenOption[0]);
    }

    String generateArtifact() {
        try {
            String json = IOUtils.toString((InputStream)new FileInputStream(new File(this.rootDirectory, MULE_ARTIFACT_FILENAME)));
            JSONObject muleArtifact = new JSONObject(json);
            if (muleArtifact.keySet().contains(MIN_MULE_VERSION)) {
                return muleArtifact.toString();
            }
        }
        catch (IOException | JSONException e) {
            e.printStackTrace();
        }
        return new JSONObject().put(MIN_MULE_VERSION, (Object)this.minMuleVersion).toString();
    }
}

