/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.output;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.logging.Log;
import org.mule.apikit.common.CollectionUtils;
import org.mule.apikit.common.CommonUtils;
import org.mule.runtime.api.deployment.meta.AbstractMuleArtifactModel;
import org.mule.runtime.api.deployment.meta.MuleApplicationModel;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptor;
import org.mule.runtime.api.deployment.meta.Product;
import org.mule.runtime.api.deployment.persistence.MuleApplicationModelJsonSerializer;
import org.mule.tools.apikit.misc.FileListUtils;

public class MuleArtifactJsonGenerator {
    private static final String API_PATH_PREFIX = "api/";
    private final File rootDirectory;
    private final String artifactName;
    private final String minMuleVersion;
    private final Set<String> configFiles = Sets.newHashSet((Object[])new String[]{"mule-config.xml"});
    private final Log log;
    private static final String MULE_ARTIFACT_LOADER_DESCRIPTOR_ID = "mule";
    private static final String RESOURCES_PATH = "src/main/resources";
    private static final String API_RESOURCES_PATH = "src/main/resources/api";
    private static final String MULE_ARTIFACT_FILENAME = "mule-artifact.json";
    private static final String EXPORTED_RESOURCES = "exportedResources";
    private static final String EXPORTED_PACKAGES = "exportedPackages";
    private final MuleApplicationModelJsonSerializer serializer = new MuleApplicationModelJsonSerializer();

    public MuleArtifactJsonGenerator(Log log, File rootDirectory, String minMuleVersion) {
        this(log, rootDirectory, rootDirectory.getName(), minMuleVersion);
    }

    private MuleArtifactJsonGenerator(Log log, File rootDirectory, String artifactName, String minMuleVersion) {
        this.log = log;
        this.rootDirectory = rootDirectory;
        this.artifactName = artifactName;
        this.minMuleVersion = minMuleVersion;
    }

    public void generate() {
        try {
            this.save(this.generateArtifact());
        }
        catch (Exception e) {
            this.log.error((CharSequence)"Error generating descriptor mule-artifact.json", (Throwable)e);
        }
    }

    private void save(MuleApplicationModel artifact) throws IOException {
        String asString = this.serializer.serialize((AbstractMuleArtifactModel)artifact);
        Files.write(Paths.get(this.rootDirectory.getPath(), MULE_ARTIFACT_FILENAME), asString.getBytes(), new OpenOption[0]);
    }

    MuleApplicationModel generateArtifact() {
        try {
            String json = IOUtils.toString((InputStream)new FileInputStream(new File(this.rootDirectory, MULE_ARTIFACT_FILENAME)));
            MuleApplicationModel artifact = (MuleApplicationModel)this.serializer.deserialize(json);
            Collection<String> exportedResources = this.collectExportedResources(artifact);
            return this.updateExportedResources(artifact, exportedResources);
        }
        catch (Exception e) {
            this.log.warn((CharSequence)"Error generating descriptor mule-artifact.json. Creating default descriptor.", (Throwable)e);
            return this.createDefaultArtifact();
        }
    }

    private Collection<String> collectExportedResources(MuleApplicationModel artifact) {
        List currentResources = (List)CommonUtils.cast(artifact.getClassLoaderModelLoaderDescriptor().getAttributes().get(EXPORTED_RESOURCES));
        List applicationResources = currentResources.stream().filter(resource -> !resource.startsWith(API_PATH_PREFIX)).collect(Collectors.toList());
        return CollectionUtils.join(this.getApiResourcesList(), applicationResources);
    }

    private MuleApplicationModel createDefaultArtifact() {
        MuleApplicationModel.MuleApplicationModelBuilder builder = this.getMuleApplicationModelBuilder();
        builder.setName(this.artifactName);
        builder.setMinMuleVersion(this.minMuleVersion);
        builder.setConfigs(this.configFiles);
        builder.setRedeploymentEnabled(true);
        builder.setRequiredProduct(Product.MULE);
        builder.withClassLoaderModelDescriptorLoader(new MuleArtifactLoaderDescriptor(MULE_ARTIFACT_LOADER_DESCRIPTOR_ID, (Map)ImmutableMap.of((Object)EXPORTED_RESOURCES, this.getApiResourcesList(), (Object)EXPORTED_PACKAGES, Collections.emptyList())));
        builder.withBundleDescriptorLoader(new MuleArtifactLoaderDescriptor(MULE_ARTIFACT_LOADER_DESCRIPTOR_ID, Collections.emptyMap()));
        return (MuleApplicationModel)builder.build();
    }

    private MuleApplicationModel updateExportedResources(MuleApplicationModel artifact, Collection<String> exportedResources) {
        MuleApplicationModel.MuleApplicationModelBuilder builder = this.getMuleApplicationModelBuilder(artifact);
        MuleArtifactLoaderDescriptor descriptor = artifact.getClassLoaderModelLoaderDescriptor();
        HashMap<String, Collection<String>> attributes = new HashMap<String, Collection<String>>(descriptor.getAttributes());
        attributes.put(EXPORTED_RESOURCES, exportedResources);
        builder.withClassLoaderModelDescriptorLoader(new MuleArtifactLoaderDescriptor(descriptor.getId(), attributes));
        return (MuleApplicationModel)builder.build();
    }

    private MuleApplicationModel.MuleApplicationModelBuilder getMuleApplicationModelBuilder() {
        return new MuleApplicationModel.MuleApplicationModelBuilder();
    }

    private MuleApplicationModel.MuleApplicationModelBuilder getMuleApplicationModelBuilder(MuleApplicationModel artifact) {
        MuleApplicationModel.MuleApplicationModelBuilder builder = this.getMuleApplicationModelBuilder();
        builder.setName(artifact.getName());
        builder.setMinMuleVersion(artifact.getMinMuleVersion());
        builder.setConfigs(artifact.getConfigs());
        builder.setRedeploymentEnabled(artifact.isRedeploymentEnabled());
        builder.setRequiredProduct(artifact.getRequiredProduct());
        builder.withBundleDescriptorLoader(artifact.getBundleDescriptorLoader());
        builder.withClassLoaderModelDescriptorLoader(artifact.getClassLoaderModelLoaderDescriptor());
        return builder;
    }

    private List<String> getApiResourcesList() {
        Path rootPath = new File(this.rootDirectory, RESOURCES_PATH).toPath();
        return FileListUtils.listFiles(this.rootDirectory.getPath(), API_RESOURCES_PATH).stream().map(p -> rootPath.relativize((Path)p).toString()).sorted().collect(Collectors.toList());
    }
}

