/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.model;

import org.mule.tools.apikit.misc.APIKitTools;
import org.mule.tools.apikit.model.HttpListenerConnection;

public class HttpListener4xConfig {
    public static final String ELEMENT_NAME = "listener-config";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String PROTOCOL_ATTRIBUTE = "protocol";
    public static final String DEFAULT_CONFIG_NAME = "httpListenerConfig";
    private String name;
    private String basePath;
    private HttpListenerConnection connection;

    public HttpListener4xConfig(String name, String baseUri) {
        this.name = name;
        String host = APIKitTools.getHostFromUri(baseUri);
        String port = APIKitTools.getPortFromUri(baseUri);
        String protocol = APIKitTools.getProtocolFromUri(baseUri);
        this.basePath = APIKitTools.getPathFromUri(baseUri, false);
        this.connection = new HttpListenerConnection.Builder(host, port, protocol).build();
    }

    public HttpListener4xConfig(String name) {
        this.name = name;
        this.basePath = "/";
        this.connection = new HttpListenerConnection.Builder("0.0.0.0", String.valueOf(8081), "HTTP").build();
    }

    public HttpListener4xConfig(String name, String host, String port, String protocol, String basePath) {
        this.name = name;
        this.basePath = basePath;
        this.connection = new HttpListenerConnection.Builder(host, port, protocol).build();
    }

    public HttpListener4xConfig(String name, String basePath, HttpListenerConnection httpListenerConnection) {
        this.name = name;
        this.basePath = basePath;
        this.connection = httpListenerConnection;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getHost() {
        return this.connection.getHost();
    }

    public String getPort() {
        return this.connection.getPort();
    }

    public String getProtocol() {
        return this.connection.getProtocol();
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }
}

