/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.mule.tools.apikit.Scaffolder;
import org.mule.tools.apikit.model.RuntimeEdition;
import org.mule.tools.apikit.model.ScaffolderReport;

public class ScaffolderAPI {
    private static final List<String> apiExtensions = Arrays.asList(".yaml", ".raml", ".yml");
    private static final List<String> appExtensions = Arrays.asList(".xml");

    public ScaffolderReport run(List<File> ramlFiles, File appDir) {
        return this.run(ramlFiles, appDir, null, "4.0.0", Scaffolder.DEFAULT_RUNTIME_EDITION);
    }

    public ScaffolderReport run(List<File> ramlFiles, File appDir, File domainDir) {
        return this.run(ramlFiles, appDir, domainDir, "4.0.0", Scaffolder.DEFAULT_RUNTIME_EDITION);
    }

    public ScaffolderReport run(List<File> ramlFiles, File appDir, File domainDir, String minMuleVersion, RuntimeEdition runtimeEdition) {
        return this.execute(ramlFiles, appDir, domainDir, minMuleVersion, runtimeEdition);
    }

    private ScaffolderReport execute(List<File> ramlFiles, File appDir, File domainDir, String minMuleVersion, RuntimeEdition runtimeEdition) {
        Scaffolder scaffolder;
        List<String> domainFiles;
        List<String> ramlFilePaths = this.retrieveFilePaths(ramlFiles, apiExtensions);
        List<String> muleXmlFiles = this.retrieveFilePaths(appDir, appExtensions);
        SystemStreamLog log = new SystemStreamLog();
        String domain = null;
        if (domainDir != null && (domainFiles = this.retrieveFilePaths(domainDir, appExtensions)).size() > 0) {
            domain = domainFiles.get(0);
            if (domainFiles.size() > 1) {
                log.info((CharSequence)("There is more than one domain file inside of the domain folder. The domain: " + domain + " will be used."));
            }
        }
        try {
            scaffolder = Scaffolder.createScaffolder((Log)log, appDir, ramlFilePaths, muleXmlFiles, domain, minMuleVersion, runtimeEdition);
        }
        catch (Exception e) {
            throw new RuntimeException("Error executing scaffolder", e);
        }
        scaffolder.run();
        return scaffolder.getScaffolderReport();
    }

    private List<String> retrieveFilePaths(File dir, List<String> extensions) {
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("File " + dir.getName() + " must be a directory");
        }
        return this.retrieveFilePaths(new ArrayList<File>(Arrays.asList(dir.listFiles())), extensions);
    }

    private List<String> retrieveFilePaths(List<File> files, List<String> extensions) {
        ArrayList<String> filePaths = new ArrayList<String>();
        if (files != null) {
            for (File file : files) {
                if (!this.containsValidExtension(file, extensions)) continue;
                filePaths.add(file.getAbsolutePath());
            }
        }
        return filePaths;
    }

    private boolean containsValidExtension(File file, List<String> extensions) {
        for (String extension : extensions) {
            if (!file.getName().toLowerCase().endsWith(extension)) continue;
            return true;
        }
        return false;
    }
}

