/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.input;

import amf.client.environment.DefaultEnvironment;
import amf.client.environment.Environment;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.logging.Log;
import org.mule.amf.impl.ParserWrapperAmf;
import org.mule.amf.impl.loader.ExchangeDependencyResourceLoader;
import org.mule.raml.implv1.ParserWrapperV1;
import org.mule.raml.implv2.ParserV2Utils;
import org.mule.raml.implv2.ParserWrapperV2;
import org.mule.raml.interfaces.ParserWrapper;
import org.mule.raml.interfaces.model.IAction;
import org.mule.raml.interfaces.model.IMimeType;
import org.mule.raml.interfaces.model.IRaml;
import org.mule.raml.interfaces.model.IResource;
import org.mule.raml.interfaces.parser.rule.IValidationReport;
import org.mule.raml.interfaces.parser.rule.IValidationResult;
import org.mule.raml.interfaces.parser.rule.Severity;
import org.mule.tools.apikit.misc.APIKitTools;
import org.mule.tools.apikit.model.API;
import org.mule.tools.apikit.model.APIFactory;
import org.mule.tools.apikit.model.ResourceActionMimeTypeTriplet;
import org.mule.tools.apikit.output.GenerationModel;
import org.raml.v2.api.loader.CompositeResourceLoader;
import org.raml.v2.api.loader.DefaultResourceLoader;
import org.raml.v2.api.loader.FileResourceLoader;
import org.raml.v2.api.loader.ResourceLoader;
import org.raml.v2.api.loader.RootRamlFileResourceLoader;

public class RAMLFilesParser {
    private Map<ResourceActionMimeTypeTriplet, GenerationModel> entries = new HashMap<ResourceActionMimeTypeTriplet, GenerationModel>();
    private final APIFactory apiFactory;
    private final Log log;
    private String vendorId;
    private String ramlVersion;
    public static final String MULE_APIKIT_PARSER = "mule.apikit.parser";

    public String getVendorId() {
        return this.vendorId;
    }

    public String getRamlVersion() {
        return this.ramlVersion;
    }

    public RAMLFilesParser(Log log, Map<File, InputStream> fileStreams, APIFactory apiFactory) {
        this.log = log;
        this.apiFactory = apiFactory;
        ArrayList<File> processedFiles = new ArrayList<File>();
        for (Map.Entry<File, InputStream> fileInputStreamEntry : fileStreams.entrySet()) {
            String content;
            File ramlFile = fileInputStreamEntry.getKey();
            try {
                content = IOUtils.toString((InputStream)fileInputStreamEntry.getValue());
            }
            catch (IOException ioe) {
                this.log.info((CharSequence)("Error loading file " + ramlFile.getName()));
                break;
            }
            try {
                ParserWrapper parserWrapper = this.getParserWrapper(ramlFile, content);
                parserWrapper.validate();
                this.vendorId = parserWrapper.getApiVendor().toString();
                IRaml raml = parserWrapper.build();
                this.ramlVersion = raml.getVersion();
                this.collectResources(ramlFile, raml.getResources(), "http://0.0.0.0:8081/api", raml.getVersion());
                processedFiles.add(ramlFile);
            }
            catch (Exception e) {
                log.info((CharSequence)("Could not parse [" + ramlFile + "] as root RAML file. Reason: " + e.getMessage()));
                log.debug((Throwable)e);
            }
        }
        if (processedFiles.size() > 0) {
            this.log.info((CharSequence)("The following RAML files were parsed correctly: " + processedFiles));
        } else {
            this.log.error((CharSequence)"RAML Root not found. None of the files were recognized as valid root RAML files.");
        }
    }

    private void collectResources(File filename, Map<String, IResource> resourceMap, String baseUri, String version) {
        for (IResource resource : resourceMap.values()) {
            for (IAction action : resource.getActions().values()) {
                API api = this.apiFactory.createAPIBinding(filename, null, baseUri, APIKitTools.getPathFromUri(baseUri, false), null, null);
                Map mimeTypes = action.getBody();
                boolean addGenericAction = false;
                if (mimeTypes != null && !mimeTypes.isEmpty()) {
                    for (IMimeType mimeType : mimeTypes.values()) {
                        if (mimeType.getSchema() != null || mimeType.getFormParameters() != null && !mimeType.getFormParameters().isEmpty()) {
                            this.addResource(api, resource, action, mimeType.getType(), version);
                            continue;
                        }
                        addGenericAction = true;
                    }
                } else {
                    addGenericAction = true;
                }
                if (!addGenericAction) continue;
                this.addResource(api, resource, action, null, version);
            }
            this.collectResources(filename, resource.getResources(), baseUri, version);
        }
    }

    private void addResource(API api, IResource resource, IAction action, String mimeType, String version) {
        String completePath = APIKitTools.getCompletePathFromBasePathAndPath(api.getHttpListenerConfig().getBasePath(), api.getPath());
        ResourceActionMimeTypeTriplet resourceActionTriplet = new ResourceActionMimeTypeTriplet(api, completePath + resource.getResolvedUri(version), action.getType().toString(), mimeType);
        this.entries.put(resourceActionTriplet, new GenerationModel(api, version, resource, action, mimeType));
    }

    public Map<ResourceActionMimeTypeTriplet, GenerationModel> getEntries() {
        return this.entries;
    }

    private ParserWrapper getParserWrapper(File apiFile, String content) throws Exception {
        ParserWrapperAmf parserWrapper;
        String parserValue;
        String apiFolderPath = null;
        File apiFileParent = null;
        if (apiFile.getParentFile() != null) {
            apiFileParent = apiFile.getParentFile();
            apiFolderPath = apiFileParent.getPath();
        }
        if ("AMF".equals(parserValue = System.getProperty(MULE_APIKIT_PARSER, "AUTO"))) {
            Environment environment = DefaultEnvironment.apply().add((amf.client.resource.ResourceLoader)new ExchangeDependencyResourceLoader(apiFolderPath));
            ParserWrapperAmf parserWrapper2 = ParserWrapperAmf.create((URI)apiFile.toURI(), (Environment)environment, (boolean)true);
            this.log.info((CharSequence)this.buildParserInfoMessage("AMF"));
            return parserWrapper2;
        }
        if ("RAML".equals(parserValue)) {
            return this.applyFallback(apiFile, content, apiFolderPath, apiFileParent, Collections.emptyList());
        }
        try {
            Environment environment = DefaultEnvironment.apply().add((amf.client.resource.ResourceLoader)new ExchangeDependencyResourceLoader(apiFolderPath));
            parserWrapper = ParserWrapperAmf.create((URI)apiFile.toURI(), (Environment)environment, (boolean)false);
        }
        catch (Exception e) {
            List<IValidationResult> errors = Collections.singletonList(IValidationResult.fromException((Exception)e));
            return this.applyFallback(apiFile, content, apiFolderPath, apiFileParent, errors);
        }
        IValidationReport validationReport = parserWrapper.validationReport();
        if (validationReport.conforms()) {
            this.log.info((CharSequence)this.buildParserInfoMessage("AMF"));
            return parserWrapper;
        }
        List errorsFound = validationReport.getResults();
        return this.applyFallback(apiFile, content, apiFolderPath, apiFileParent, errorsFound);
    }

    private ParserWrapper applyFallback(File apiFile, String content, String apiFolderPath, File apiFileParent, List<IValidationResult> errorsFound) {
        ParserWrapperV1 parserWrapper;
        if (ParserV2Utils.useParserV2((String)content)) {
            CompositeResourceLoader resourceLoader = new CompositeResourceLoader(new ResourceLoader[]{new RootRamlFileResourceLoader(apiFileParent), new DefaultResourceLoader(), new FileResourceLoader(apiFolderPath), new org.mule.raml.implv2.loader.ExchangeDependencyResourceLoader(apiFolderPath)});
            parserWrapper = new ParserWrapperV2(apiFile.getPath(), (ResourceLoader)resourceLoader);
        } else {
            parserWrapper = new ParserWrapperV1(apiFile.getAbsolutePath());
        }
        if (parserWrapper.validationReport().conforms()) {
            this.log.info((CharSequence)this.buildParserInfoMessage("RAML Parser"));
            this.logErrors(errorsFound, Severity.WARNING);
            return parserWrapper;
        }
        this.logErrors(errorsFound);
        throw new RuntimeException(RAMLFilesParser.buildErrorMessage(errorsFound));
    }

    private String buildParserInfoMessage(String parser) {
        return String.format("Using %s to load APIs", parser);
    }

    private void logErrors(List<IValidationResult> validationResults) {
        validationResults.stream().forEach(error -> this.logError((IValidationResult)error, error.getSeverity()));
    }

    private void logErrors(List<IValidationResult> validationResults, Severity overridenSeverity) {
        validationResults.stream().forEach(error -> this.logError((IValidationResult)error, overridenSeverity));
    }

    private void logError(IValidationResult error, Severity severity) {
        if (severity == Severity.INFO) {
            this.log.info((CharSequence)error.getMessage());
        } else if (severity == Severity.WARNING) {
            this.log.warn((CharSequence)error.getMessage());
        } else {
            this.log.error((CharSequence)error.getMessage());
        }
    }

    private static String buildErrorMessage(List<IValidationResult> validationResults) {
        StringBuilder message = new StringBuilder("Invalid API descriptor -- errors found: ");
        message.append(validationResults.size()).append("\n\n");
        for (IValidationResult error : validationResults) {
            message.append(error.getMessage()).append("\n");
        }
        return message.toString();
    }
}

