/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.input;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.maven.plugin.logging.Log;
import org.mule.parser.service.ParserService;
import org.mule.parser.service.logger.Logger;
import org.mule.raml.interfaces.ParserWrapper;
import org.mule.raml.interfaces.loader.ResourceLoader;
import org.mule.raml.interfaces.model.IAction;
import org.mule.raml.interfaces.model.IMimeType;
import org.mule.raml.interfaces.model.IRaml;
import org.mule.raml.interfaces.model.IResource;
import org.mule.raml.interfaces.model.api.ApiRef;
import org.mule.tools.apikit.misc.APIKitTools;
import org.mule.tools.apikit.model.API;
import org.mule.tools.apikit.model.APIFactory;
import org.mule.tools.apikit.model.ResourceActionMimeTypeTriplet;
import org.mule.tools.apikit.model.ScaffolderReport;
import org.mule.tools.apikit.model.ScaffolderResourceLoader;
import org.mule.tools.apikit.output.GenerationModel;

public class RAMLFilesParser {
    private Map<ResourceActionMimeTypeTriplet, GenerationModel> entries = new HashMap<ResourceActionMimeTypeTriplet, GenerationModel>();
    private final APIFactory apiFactory;
    private final Log log;
    private String ramlVersion;
    private String parseStatus = ScaffolderReport.SUCCESS;
    private String errorMessage;
    private static String vendorId = "RAML";
    public static final String MULE_APIKIT_PARSER = "mule.apikit.parser";

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getVendorId() {
        return vendorId;
    }

    public String getRamlVersion() {
        return this.ramlVersion;
    }

    public String getParseStatus() {
        return this.parseStatus;
    }

    private RAMLFilesParser(Log log, List<ApiRef> specs, APIFactory apiFactory, ScaffolderResourceLoader scaffolderResourceLoader) {
        this.log = log;
        this.apiFactory = apiFactory;
        ArrayList<ApiRef> processedFiles = new ArrayList<ApiRef>();
        for (ApiRef spec : specs) {
            try {
                ParserWrapper parserWrapper = this.getParserWrapper(spec, scaffolderResourceLoader);
                parserWrapper.validate();
                vendorId = parserWrapper.getApiVendor().toString();
                IRaml raml = parserWrapper.build();
                this.ramlVersion = raml.getVersion();
                this.collectResources(spec.getLocation(), raml.getResources(), "http://0.0.0.0:8081/api", raml.getVersion());
                processedFiles.add(spec);
            }
            catch (Exception e) {
                String reason = e.getMessage() == null ? "" : " Reason: " + e.getMessage();
                log.info((CharSequence)("Could not parse [" + spec.getLocation() + "] as root RAML file." + reason));
                log.debug((Throwable)e);
            }
        }
        if (processedFiles.size() > 0) {
            this.log.info((CharSequence)("The following RAML files were parsed correctly: " + processedFiles));
        } else {
            this.parseStatus = ScaffolderReport.FAILED;
            this.errorMessage = "RAML Root not found. None of the files were recognized as valid root RAML files.";
            this.log.error((CharSequence)this.errorMessage);
        }
    }

    public static RAMLFilesParser create(Log log, Map<File, InputStream> fileStreams, APIFactory apiFactory) {
        List<ApiRef> specs = fileStreams.entrySet().stream().map(e -> ApiRef.create((String)((File)e.getKey()).getAbsolutePath())).collect(Collectors.toList());
        return new RAMLFilesParser(log, specs, apiFactory, null);
    }

    public static RAMLFilesParser create(Log log, Map<String, InputStream> apis, ScaffolderResourceLoader scaffolderResourceLoader, APIFactory apiFactory) {
        List<ApiRef> specs = apis.entrySet().stream().map(e -> ApiRef.create((String)((String)e.getKey()))).collect(Collectors.toList());
        return new RAMLFilesParser(log, specs, apiFactory, scaffolderResourceLoader);
    }

    private void collectResources(String filePath, Map<String, IResource> resourceMap, String baseUri, String version) {
        for (IResource resource : resourceMap.values()) {
            for (IAction action : resource.getActions().values()) {
                API api = this.apiFactory.createAPIBinding(filePath, null, baseUri, APIKitTools.getPathFromUri(baseUri, false), null, null);
                Map mimeTypes = action.getBody();
                boolean addGenericAction = false;
                if (mimeTypes != null && !mimeTypes.isEmpty()) {
                    for (IMimeType mimeType : mimeTypes.values()) {
                        if (mimeType.getSchema() != null || mimeType.getFormParameters() != null && !mimeType.getFormParameters().isEmpty()) {
                            this.addResource(api, resource, action, mimeType.getType(), version);
                            continue;
                        }
                        addGenericAction = true;
                    }
                } else {
                    addGenericAction = true;
                }
                if (!addGenericAction) continue;
                this.addResource(api, resource, action, null, version);
            }
            this.collectResources(filePath, resource.getResources(), baseUri, version);
        }
    }

    private void addResource(API api, IResource resource, IAction action, String mimeType, String version) {
        String completePath = APIKitTools.getCompletePathFromBasePathAndPath(api.getHttpListenerConfig().getBasePath(), api.getPath());
        ResourceActionMimeTypeTriplet resourceActionTriplet = new ResourceActionMimeTypeTriplet(api, completePath + resource.getResolvedUri(version), action.getType().toString(), mimeType);
        this.entries.put(resourceActionTriplet, new GenerationModel(api, version, resource, action, mimeType));
    }

    public Map<ResourceActionMimeTypeTriplet, GenerationModel> getEntries() {
        return this.entries;
    }

    private ParserWrapper getParserWrapper(ApiRef apiRef, ScaffolderResourceLoader scaffolderResourceLoader) {
        apiRef = scaffolderResourceLoader == null ? ApiRef.create((String)apiRef.getLocation()) : ApiRef.create((String)apiRef.getLocation(), (ResourceLoader)scaffolderResourceLoader);
        ParserService parserService = new ParserService((Logger)LoggerWrapper.getLogger(this.log));
        ParserWrapper parser = parserService.getParser(apiRef);
        this.log.info((CharSequence)this.buildParserInfoMessage(parser.getParserType().name()));
        return parser;
    }

    private String buildParserInfoMessage(String parser) {
        return String.format("Using %s to load APIs", parser);
    }

    private static class LoggerWrapper
    implements Logger {
        private final Log logger;

        private LoggerWrapper(Log logger) {
            this.logger = logger;
        }

        static LoggerWrapper getLogger(Log logger) {
            return new LoggerWrapper(logger);
        }

        public void debug(String msg) {
            this.logger.debug((CharSequence)msg);
        }

        public void debug(String msg, Throwable error) {
            this.logger.debug((CharSequence)msg, error);
        }

        public void info(String msg) {
            this.logger.info((CharSequence)msg);
        }

        public void info(String msg, Throwable error) {
            this.logger.info((CharSequence)msg, error);
        }

        public void warn(String msg) {
            this.logger.warn((CharSequence)msg);
        }

        public void warn(String msg, Throwable error) {
            this.logger.warn((CharSequence)msg, error);
        }

        public void error(String msg) {
            this.logger.error((CharSequence)msg);
        }

        public void error(String msg, Throwable error) {
            this.logger.error((CharSequence)msg, error);
        }
    }
}

