/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.model;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.codehaus.plexus.util.FileUtils;
import org.mule.raml.interfaces.common.APISyncUtils;
import org.mule.tools.apikit.model.API;
import org.mule.tools.apikit.model.APIKitConfig;
import org.mule.tools.apikit.model.HttpListener4xConfig;

public class APIFactory {
    private static final String RESOURCE_API_FOLDER = "src" + File.separator + "main" + File.separator + "resources" + File.separator + "api" + File.separator;
    private Map<String, API> apis = new HashMap<String, API>();
    private Map<String, HttpListener4xConfig> domainHttpListenerConfigs = new HashMap<String, HttpListener4xConfig>();

    public APIFactory(Map<String, HttpListener4xConfig> domainHttpListenerConfigs) {
        this.domainHttpListenerConfigs.putAll(domainHttpListenerConfigs);
    }

    public APIFactory() {
    }

    public API createAPIBindingInboundEndpoint(String apiFileName, File xmlFile, String baseUri, String path, APIKitConfig config) {
        return this.createAPIBinding(apiFileName, xmlFile, baseUri, path, config, null);
    }

    public API createAPIBinding(String apiFilePath, File xmlFile, String baseUri, String path, APIKitConfig config, HttpListener4xConfig httpListenerConfig) {
        Validate.notNull((Object)apiFilePath);
        String relativePath = this.getRelativePath(apiFilePath);
        if (this.apis.containsKey(relativePath)) {
            API api = this.apis.get(relativePath);
            if (api.getXmlFile() == null && xmlFile != null) {
                api.setXmlFile(xmlFile);
            }
            return api;
        }
        String id = this.buildApiId(relativePath);
        API api = new API(id, relativePath, xmlFile, baseUri, path, config);
        if (httpListenerConfig == null) {
            if (this.domainHttpListenerConfigs.size() > 0) {
                api.setHttpListenerConfig(this.getFirstLC());
            } else {
                api.setDefaultHttpListenerConfig();
            }
        } else {
            api.setHttpListenerConfig(httpListenerConfig);
        }
        api.setConfig(config);
        this.apis.put(relativePath, api);
        return api;
    }

    private String buildApiId(String ramlFilePath) {
        String id;
        String apiId = APISyncUtils.isSyncProtocol((String)ramlFilePath) ? FilenameUtils.removeExtension((String)APISyncUtils.getFileName((String)ramlFilePath)) : FilenameUtils.removeExtension((String)FileUtils.basename((String)ramlFilePath)).trim();
        List apiIds = this.apis.values().stream().map(API::getId).collect(Collectors.toList());
        List configNames = this.apis.values().stream().filter(a -> a.getConfig() != null).map(a -> a.getConfig().getName()).collect(Collectors.toList());
        List httpConfigNames = this.apis.values().stream().filter(a -> a.getHttpListenerConfig() != null).map(a -> a.getHttpListenerConfig().getName()).collect(Collectors.toList());
        int count = 0;
        while (apiIds.contains(id = ++count > 1 ? apiId + "-" + count : apiId) || configNames.contains(id + "-" + "config") || httpConfigNames.contains(id + "-" + "httpListenerConfig")) {
        }
        return id;
    }

    private String getRelativePath(String path) {
        if (!APISyncUtils.isSyncProtocol((String)path) && !path.startsWith("http://") && !path.startsWith("https://") && path.contains(RESOURCE_API_FOLDER)) {
            return path.substring(path.lastIndexOf(RESOURCE_API_FOLDER) + RESOURCE_API_FOLDER.length());
        }
        return path;
    }

    public Map<String, HttpListener4xConfig> getDomainHttpListenerConfigs() {
        return this.domainHttpListenerConfigs;
    }

    private HttpListener4xConfig getFirstLC() {
        ArrayList<Map.Entry<String, HttpListener4xConfig>> numericPortsList = new ArrayList<Map.Entry<String, HttpListener4xConfig>>();
        ArrayList<Map.Entry<String, HttpListener4xConfig>> nonNumericPortsList = new ArrayList<Map.Entry<String, HttpListener4xConfig>>();
        for (Map.Entry<String, HttpListener4xConfig> entry : this.domainHttpListenerConfigs.entrySet()) {
            if (StringUtils.isNumeric((String)entry.getValue().getPort())) {
                numericPortsList.add(entry);
                continue;
            }
            nonNumericPortsList.add(entry);
        }
        Collections.sort(numericPortsList, new Comparator<Map.Entry<String, HttpListener4xConfig>>(){

            @Override
            public int compare(Map.Entry<String, HttpListener4xConfig> o1, Map.Entry<String, HttpListener4xConfig> o2) {
                Integer i1 = Integer.parseInt(o1.getValue().getPort());
                Integer i2 = Integer.parseInt(o2.getValue().getPort());
                return i1.compareTo(i2);
            }
        });
        numericPortsList.addAll(nonNumericPortsList);
        return (HttpListener4xConfig)((Map.Entry)numericPortsList.get(0)).getValue();
    }
}

