/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.output;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.mule.apikit.common.FlowName;
import org.mule.raml.interfaces.model.IAction;
import org.mule.raml.interfaces.model.IResource;
import org.mule.raml.interfaces.model.IResponse;
import org.mule.tools.apikit.model.API;

public class GenerationModel
implements Comparable<GenerationModel> {
    private static final String OAS_DEFAULT_STATUS_CODE = "default";
    private final String verb;
    private IAction action;
    private IResource resource;
    private String mimeType;
    private String version;
    private List<String> splitPath;
    private API api;

    public GenerationModel(API api, String version, IResource resource, IAction action) {
        this(api, version, resource, action, null);
    }

    public GenerationModel(API api, String version, IResource resource, IAction action, String mimeType) {
        this.api = api;
        Validate.notNull((Object)api);
        Validate.notNull((Object)action);
        Validate.notNull((Object)action.getType());
        Validate.notNull((Object)resource.getResolvedUri(version));
        this.resource = resource;
        this.action = action;
        this.splitPath = new ArrayList<String>(Arrays.asList(this.resource.getResolvedUri(version).split("/")));
        this.verb = action.getType().toString();
        this.mimeType = mimeType;
        this.version = version;
        if (!this.splitPath.isEmpty()) {
            this.splitPath.remove(0);
            this.splitPath.remove(0);
        }
    }

    public String getVerb() {
        return this.verb;
    }

    public String getStringFromActionType() {
        switch (this.action.getType()) {
            case GET: {
                return "retrieve";
            }
            case POST: {
                return "update";
            }
            case PUT: {
                return "create";
            }
            case DELETE: {
                return "delete";
            }
        }
        return this.action.getType().toString().toLowerCase();
    }

    public String getExampleWrapper() {
        Map responses = this.action.getResponses();
        return this.getExampleWrapper(responses);
    }

    private String getExampleWrapper(Map<String, IResponse> responses) {
        String example;
        block3: {
            IResponse response;
            LinkedHashMap validResponses = responses.entrySet().stream().sorted(GenerationModel.getStatusCodeComparator()).collect(Collectors.toMap(e -> OAS_DEFAULT_STATUS_CODE.equalsIgnoreCase((String)e.getKey()) ? "200" : (String)e.getKey(), Map.Entry::getValue, (k, v) -> v, LinkedHashMap::new));
            if (validResponses.isEmpty()) {
                return null;
            }
            IResponse responseOk = (IResponse)validResponses.get("200");
            example = null;
            if (responseOk != null) {
                example = GenerationModel.getExampleFromResponse(responseOk);
            }
            if (example != null) break block3;
            Iterator iterator = validResponses.values().iterator();
            while (iterator.hasNext() && (example = GenerationModel.getExampleFromResponse(response = (IResponse)iterator.next())) == null) {
            }
        }
        return example;
    }

    private static String getExampleFromResponse(IResponse response) {
        Map examples = response.getExamples();
        if (examples.isEmpty()) {
            return null;
        }
        if (examples.containsKey("application/json")) {
            return (String)examples.get("application/json");
        }
        return (String)examples.values().iterator().next();
    }

    private static Comparator<Map.Entry<String, IResponse>> getStatusCodeComparator() {
        return (c1, c2) -> {
            String c1Key = (String)c1.getKey();
            String c2Key = (String)c2.getKey();
            if (OAS_DEFAULT_STATUS_CODE.equalsIgnoreCase(c1Key) && OAS_DEFAULT_STATUS_CODE.equalsIgnoreCase(c2Key)) {
                return 0;
            }
            if (OAS_DEFAULT_STATUS_CODE.equalsIgnoreCase(c1Key)) {
                return -1;
            }
            if (OAS_DEFAULT_STATUS_CODE.equalsIgnoreCase(c2Key)) {
                return 1;
            }
            return c1Key.compareTo(c2Key);
        };
    }

    private static boolean isOkResponse(String code) {
        try {
            Integer value = Integer.valueOf(code);
            return value >= 200 && value < 300;
        }
        catch (NumberFormatException ignore) {
            return OAS_DEFAULT_STATUS_CODE.equalsIgnoreCase(code);
        }
    }

    public String getName() {
        StringBuffer buff;
        StringBuilder name = new StringBuilder();
        name.append(this.getStringFromActionType());
        String resourceName = this.resource.getDisplayName();
        if (resourceName == null) {
            buff = new StringBuffer();
            for (String i : this.splitPath) {
                buff.append(StringUtils.capitalize((String)i));
            }
            resourceName = buff.toString();
        }
        name.append(resourceName);
        if (this.mimeType != null) {
            buff = new StringBuffer();
            for (String part : this.mimeType.split("/")) {
                buff.append(StringUtils.capitalize((String)part));
            }
            name.append(buff.toString());
        }
        return name.toString().replace(" ", "");
    }

    public String getRelativeURI() {
        return "/" + StringUtils.join((Object[])this.splitPath.toArray(), (String)"/");
    }

    public API getApi() {
        return this.api;
    }

    public String getContentType() {
        if (this.action.getResponses() != null) {
            for (String response : this.action.getResponses().keySet()) {
                int statusCode = Integer.parseInt(response);
                if (statusCode < 200 || statusCode >= 299 || ((IResponse)this.action.getResponses().get(response)).getBody() == null || ((IResponse)this.action.getResponses().get(response)).getBody().size() <= 0) continue;
                return (String)((IResponse)this.action.getResponses().get(response)).getBody().keySet().toArray()[0];
            }
        }
        return null;
    }

    public String getFlowName() {
        StringBuilder flowName = new StringBuilder("");
        flowName.append(this.action.getType().toString().toLowerCase()).append(":").append(this.resource.getResolvedUri(this.version));
        if (this.mimeType != null) {
            flowName.append(":").append(this.mimeType);
        }
        if (this.api.getConfig() != null && !StringUtils.isEmpty((String)this.api.getConfig().getName())) {
            flowName.append(":").append(this.api.getConfig().getName());
        }
        return FlowName.encode((String)flowName.toString());
    }

    @Override
    public int compareTo(@Nonnull GenerationModel generationModel) {
        return this.getName().compareTo(generationModel.getName());
    }

    public List<String> getUriParameters() {
        this.action.getResolvedUriParameters();
        ArrayList<String> result = new ArrayList<String>();
        for (String part : Lists.newArrayList((Object[])this.resource.getResolvedUri(this.version).split("/"))) {
            if (!part.startsWith("{") || !part.endsWith("}")) continue;
            result.add(part.substring(1, part.length() - 1));
        }
        return result;
    }
}

