/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.input.parsers;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.filter.Filters;
import org.jdom2.xpath.XPathExpression;
import org.jdom2.xpath.XPathFactory;
import org.mule.raml.interfaces.common.APISyncUtils;
import org.mule.tools.apikit.input.parsers.MuleConfigFileParser;
import org.mule.tools.apikit.misc.APIKitTools;
import org.mule.tools.apikit.model.API;
import org.mule.tools.apikit.model.APIFactory;
import org.mule.tools.apikit.model.APIKitConfig;
import org.mule.tools.apikit.model.HttpListener4xConfig;

public class APIKitRoutersParser
implements MuleConfigFileParser {
    private final Map<String, APIKitConfig> apikitConfigs;
    private final Map<String, HttpListener4xConfig> httpListenerConfigs;
    private final Set<String> apiFilePaths;
    private final File file;
    private final APIFactory apiFactory;

    public APIKitRoutersParser(Map<String, APIKitConfig> apikitConfigs, Map<String, HttpListener4xConfig> httpListenerConfigs, Set<String> apiFilePaths, File file, APIFactory apiFactory) {
        this.apikitConfigs = apikitConfigs;
        this.httpListenerConfigs = httpListenerConfigs;
        this.apiFilePaths = apiFilePaths;
        this.file = file;
        this.apiFactory = apiFactory;
    }

    @Override
    public Map<String, API> parse(Document document) {
        HashMap<String, API> includedApis = new HashMap<String, API>();
        XPathExpression xp = XPathFactory.instance().compile("//*/*[local-name()='router']", Filters.element((Namespace)APIKitTools.API_KIT_NAMESPACE.getNamespace()));
        List elements = xp.evaluate((Object)document);
        for (Element element : elements) {
            APIKitConfig config = this.getApikitConfig(element);
            for (String apiFilePath : this.apiFilePaths) {
                String configId;
                String apiPath = config.getApi() == null ? config.getRaml() : config.getApi();
                if (!this.compareApisLocation(apiPath, apiFilePath)) continue;
                Element source = this.findListenerOrInboundEndpoint(element.getParentElement().getChildren());
                String string = configId = config.getName() != null ? config.getName() : "noNameConfig";
                if ("listener".equals(source.getName())) {
                    includedApis.put(configId, this.handleListenerSource(source, apiFilePath, config));
                    continue;
                }
                if ("inbound-endpoint".equals(source.getName())) {
                    includedApis.put(configId, this.handleInboundEndpointSource(source, apiFilePath, config));
                    continue;
                }
                throw new IllegalStateException("The first element of the main flow must be an inbound-endpoint or listener");
            }
        }
        return includedApis;
    }

    private boolean compareApisLocation(String configRaml, String currentRootRaml) {
        if (APISyncUtils.isSyncProtocol((String)configRaml) && APISyncUtils.isSyncProtocol((String)currentRootRaml)) {
            return APISyncUtils.compareResourcesLocation((String)configRaml, (String)currentRootRaml, (Boolean)false);
        }
        return currentRootRaml.endsWith(configRaml);
    }

    public APIKitConfig getApikitConfig(Element element) throws IllegalStateException {
        Attribute configRef = element.getAttribute("config-ref");
        String configId = configRef != null ? configRef.getValue() : "noNameConfig";
        APIKitConfig config = this.apikitConfigs.get(configId);
        if (config == null) {
            throw new IllegalStateException("An Apikit configuration is mandatory.");
        }
        return config;
    }

    public API handleListenerSource(Element source, String apiFilePath, APIKitConfig config) {
        HttpListener4xConfig httpListenerConfig = this.getHTTPListenerConfig(source);
        String path = this.getPathFromInbound(source);
        return this.apiFactory.createAPIBinding(apiFilePath, this.file, null, path, config, httpListenerConfig);
    }

    public API handleInboundEndpointSource(Element source, String apiFilePath, APIKitConfig config) {
        String baseUri = null;
        String path = source.getAttributeValue("path");
        if (path == null) {
            baseUri = source.getAttributeValue("address");
            if (baseUri == null) {
                throw new IllegalStateException("Neither 'path' nor 'address' attribute was used. Cannot retrieve base URI.");
            }
            path = APIKitTools.getPathFromUri(baseUri, false);
        } else if (!path.startsWith("/")) {
            path = "/" + path;
        }
        return this.apiFactory.createAPIBinding(apiFilePath, this.file, baseUri, path, config, null);
    }

    private Element findListenerOrInboundEndpoint(List<Element> elements) {
        for (Element element : elements) {
            if (!"listener".equals(element.getName()) && !"inbound-endpoint".equals(element.getName())) continue;
            return element;
        }
        throw new IllegalStateException("The main flow must have an inbound-endpoint or listener");
    }

    private HttpListener4xConfig getHTTPListenerConfig(Element inbound) {
        Attribute httpListenerConfigRef = inbound.getAttribute("config-ref");
        String httpListenerConfigId = httpListenerConfigRef != null ? httpListenerConfigRef.getValue() : "httpListenerConfig";
        HttpListener4xConfig httpListenerConfig = this.httpListenerConfigs.get(httpListenerConfigId);
        if (httpListenerConfig == null) {
            throw new IllegalStateException("An HTTP Listener configuration is mandatory.");
        }
        return httpListenerConfig;
    }

    private String getPathFromInbound(Element inbound) {
        String address = inbound.getAttributeValue("address");
        if (address != null) {
            return APIKitTools.getPathFromUri(address, false);
        }
        String path = inbound.getAttributeValue("path");
        if (path == null) {
            path = "";
        } else if (!path.startsWith("/")) {
            path = "/" + path;
        }
        return path;
    }
}

