/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.output.scopes;

import org.apache.commons.lang.StringUtils;
import org.jdom2.Content;
import org.jdom2.Element;
import org.mule.tools.apikit.misc.APIKitTools;
import org.mule.tools.apikit.model.APIKitConfig;
import org.mule.tools.apikit.output.scopes.Scope;

public class APIKitConfigScope
implements Scope {
    private final Element mule;
    private final APIKitConfig config;
    private Integer index;

    public APIKitConfigScope(APIKitConfig config, Element mule, Integer index) {
        this.mule = mule;
        this.config = config;
        this.index = index;
    }

    @Override
    public Element generate() {
        Element config = null;
        if (this.config != null) {
            config = new Element("config", APIKitTools.API_KIT_NAMESPACE.getNamespace());
            if (!StringUtils.isEmpty((String)this.config.getName())) {
                config.setAttribute("name", this.config.getName());
            }
            if (this.config.getApi() != null) {
                config.setAttribute("api", this.config.getApi());
            }
            if (this.config.getRaml() != null) {
                config.setAttribute("raml", this.config.getRaml());
            }
            if (this.config.isExtensionEnabled() != null) {
                config.setAttribute("extensionEnabled", String.valueOf(this.config.isExtensionEnabled()));
            }
            if (this.config.getOutboundHeadersMapName() != null) {
                config.setAttribute("outboundHeadersMapName", this.config.getOutboundHeadersMapName());
            }
            if (this.config.getHttpStatusVarName() != null) {
                config.setAttribute("httpStatusVarName", this.config.getHttpStatusVarName());
            }
            if (this.index != null) {
                this.mule.addContent(this.index.intValue(), (Content)config);
            } else {
                this.mule.addContent((Content)config);
            }
        }
        return config;
    }
}

