/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.model;

import amf.client.remote.Content;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.mule.raml.interfaces.common.APISyncUtils;
import org.mule.tools.apikit.model.ScaffolderResourceLoader;
import org.raml.parser.loader.ResourceLoader;

public class ScaffolderResourceLoaderWrapper
implements org.raml.v2.api.loader.ResourceLoader,
ResourceLoader,
amf.client.resource.ResourceLoader {
    private final String rootRamlResource;
    ScaffolderResourceLoader scaffolderResourceLoader;

    public ScaffolderResourceLoaderWrapper(ScaffolderResourceLoader scaffolderResourceLoader, String rootRamlName) {
        this.scaffolderResourceLoader = scaffolderResourceLoader;
        this.rootRamlResource = this.getRootRamlResource(rootRamlName);
    }

    private String getRootRamlResource(String rootRamlResource) {
        return rootRamlResource.substring(0, rootRamlResource.lastIndexOf(":") + 1);
    }

    @Nullable
    public InputStream fetchResource(String s) {
        InputStream stream = null;
        if (s.startsWith("/")) {
            s = s.substring(1);
        }
        if (APISyncUtils.isExchangeModules((String)s)) {
            stream = this.scaffolderResourceLoader.getResourceAsStream(s);
        }
        if (stream != null) {
            return stream;
        }
        if (APISyncUtils.isSyncProtocol((String)s)) {
            return this.scaffolderResourceLoader.getResourceAsStream(s);
        }
        return this.scaffolderResourceLoader.getResourceAsStream(this.rootRamlResource + s);
    }

    public File getFile(String resource) throws MalformedURLException {
        return FileUtils.toFile((URL)this.scaffolderResourceLoader.getResource(resource).toURL());
    }

    public CompletableFuture<Content> fetch(String s) {
        CompletableFuture<Content> future = new CompletableFuture<Content>();
        if (s.startsWith("/")) {
            s = s.substring(1);
        }
        if (!APISyncUtils.isSyncProtocol((String)s) && !APISyncUtils.isExchangeModules((String)s)) {
            s = this.rootRamlResource + s;
        }
        if (s == null || s.isEmpty()) {
            future.completeExceptionally(new Exception("Failed to apply."));
            return future;
        }
        try {
            Content content = new Content(IOUtils.toString((InputStream)this.scaffolderResourceLoader.getResourceAsStream(s)), this.scaffolderResourceLoader.getResource(s).toURL().toString());
            future.complete(content);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return future;
    }

    private CompletableFuture<Content> fail() {
        return CompletableFuture.supplyAsync(() -> {
            throw new RuntimeException("Failed to apply.");
        });
    }
}

