/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.output;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.logging.Log;
import org.json.JSONException;
import org.json.JSONObject;
import org.mule.parser.service.ComponentScaffoldingError;
import org.mule.parser.service.SimpleScaffoldingError;

public class MuleArtifactJsonGenerator {
    private final File rootDirectory;
    private final String minMuleVersion;
    private final Log log;
    private final List<ComponentScaffoldingError> errors = new LinkedList<ComponentScaffoldingError>();
    private static final String MULE_ARTIFACT_FILENAME = "mule-artifact.json";
    private static final String MIN_MULE_VERSION = "minMuleVersion";

    public MuleArtifactJsonGenerator(Log log, File rootDirectory, String minMuleVersion) {
        this.log = log;
        this.rootDirectory = rootDirectory;
        this.minMuleVersion = minMuleVersion;
    }

    public List<ComponentScaffoldingError> getErrors() {
        return this.errors;
    }

    public void generate() {
        try {
            this.save(this.generateArtifact());
        }
        catch (Exception e) {
            this.log.error((CharSequence)"Error generating descriptor mule-artifact.json", (Throwable)e);
            this.errors.add((ComponentScaffoldingError)new SimpleScaffoldingError(String.format("Error generating descriptor mule-artifact.json : %s", e.getMessage())));
        }
    }

    private void save(String artifactJson) throws IOException {
        Files.write(Paths.get(this.rootDirectory.getPath(), MULE_ARTIFACT_FILENAME), artifactJson.getBytes(), new OpenOption[0]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String generateArtifact() {
        try (FileInputStream input = new FileInputStream(new File(this.rootDirectory, MULE_ARTIFACT_FILENAME));){
            String json = IOUtils.toString((InputStream)input);
            JSONObject muleArtifact = new JSONObject(json);
            if (!muleArtifact.keySet().contains(MIN_MULE_VERSION)) return new JSONObject().put(MIN_MULE_VERSION, (Object)this.minMuleVersion).toString();
            String string = muleArtifact.toString();
            return string;
        }
        catch (IOException | JSONException e) {
            e.printStackTrace();
        }
        return new JSONObject().put(MIN_MULE_VERSION, (Object)this.minMuleVersion).toString();
    }
}

