/**
 * Mule ESB Tools
 *
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tools.artifact.archiver.internal;

import java.io.File;

import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.zip.ZipArchiver;
import org.codehaus.plexus.util.DirectoryScanner;

/**
 * Creates the structure and archive for a Mule Application
 */
public class MuleArchiver extends ZipArchiver
{
    public final static String LIB_LOCATION = "lib" + File.separator;
    public final static String CLASSES_LOCATION = "classes" + File.separator;
    public final static String ROOT_LOCATION = "";

    public void addResourcesFile(final File file) throws ArchiverException
    {
        addResourcesFileToPath(file, ROOT_LOCATION);
    }

    public void addResourcesFileToPath(final File file, String path) throws ArchiverException
    {
        addFile(file, path + file.getName());
    }

    public void addResources(final File directoryName) throws ArchiverException
    {
        addResourcesToPath(directoryName, ROOT_LOCATION);
    }

    public void addResourcesToPath(final File directoryName, String path) throws ArchiverException
    {
        addDirectory(directoryName, path, null, addDefaultExcludes(null));
    }

    public void addLib(final File file) throws ArchiverException
    {
        addFile(file, LIB_LOCATION + file.getName());
    }

    /**
     * add files under /classes
     */
    public void addClasses(File directoryName, String[] includes, String[] excludes)
            throws ArchiverException
    {
        addDirectory(directoryName, CLASSES_LOCATION, includes, addDefaultExcludes(excludes));
    }

    private String[] addDefaultExcludes(String[] excludes)
    {
        if ((excludes == null) || (excludes.length == 0))
        {
            return DirectoryScanner.DEFAULTEXCLUDES;
        }
        else
        {
            String[] newExcludes = new String[excludes.length + DirectoryScanner.DEFAULTEXCLUDES.length];

            System.arraycopy(DirectoryScanner.DEFAULTEXCLUDES, 0, newExcludes, 0, DirectoryScanner.DEFAULTEXCLUDES.length);
            System.arraycopy(excludes, 0, newExcludes, DirectoryScanner.DEFAULTEXCLUDES.length, excludes.length);

            return newExcludes;
        }
    }

}