/*
 * Mule ESB Tools
 * <p>
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * <p>
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tools.artifact.archiver.internal.packaging.type;

import org.mule.tools.artifact.archiver.api.PackageBuilder;

import java.io.File;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/**
 * Packaging type that knows how to build a package containing binaries and source files.
 */
public class BinariesAndSourcesType implements PackagingType {
    private final PackagingType binariesType = new BinariesType();
    private final PackagingType sourcesType = new SourcesType();

    @Override
    public PackageBuilder applyPackaging(PackageBuilder packageBuilder, Map<String, File> fileMap) {
        return packageBuilder.withPlugins(fileMap.get(PackageBuilder.PLUGINS_FOLDER))
                .withLib(fileMap.get(PackageBuilder.LIB_FOLDER))
                .withClasses(fileMap.get(PackageBuilder.CLASSES_FOLDER))
                .withMule(fileMap.get(PackageBuilder.MULE_FOLDER))
                .withMetaInf(fileMap.get(PackageBuilder.METAINF_FOLDER))
                .withMuleAppProperties(fileMap.get(PackageBuilder.MULE_APP_PROPERTIES))
                .withMuleDeployProperties(fileMap.get(PackageBuilder.MULE_DEPLOY_PROPERTIES))
                .withPom(fileMap.get(PackageBuilder.POM));
    }

    @Override
    public Set<String> listFiles() {
        Set<String> files = new HashSet<>();
        files.addAll(binariesType.listFiles());
        files.addAll(sourcesType.listFiles());
        return files;
    }

    @Override
    public Set<String> listDirectories() {
        Set<String> files = new HashSet<>();
        files.addAll(binariesType.listDirectories());
        files.addAll(sourcesType.listDirectories());
        return files;
    }
}