/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.artifact.archiver.internal;

import java.io.File;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.zip.ZipArchiver;
import org.codehaus.plexus.util.DirectoryScanner;

public class MuleArchiver
extends ZipArchiver {
    public static final String ROOT_LOCATION = "";
    public static final String PLUGINS_LOCATION = "plugins" + File.separator;
    public static final String LIB_LOCATION = "lib" + File.separator;
    public static final String CLASSES_LOCATION = "classes" + File.separator;
    public static final String MULE_LOCATION = "mule" + File.separator;
    public static final String METAINF_LOCATION = "META-INF" + File.separator;

    public void addClasses(File file) throws ArchiverException {
        this.addFile(file, CLASSES_LOCATION + file.getName());
    }

    public void addClasses(File directoryName, String[] includes, String[] excludes) throws ArchiverException {
        this.addDirectory(directoryName, CLASSES_LOCATION, includes, this.addDefaultExcludes(excludes));
    }

    public void addLib(File file) throws ArchiverException {
        this.addFile(file, LIB_LOCATION + file.getName());
    }

    public void addLib(File directoryName, String[] includes, String[] excludes) throws ArchiverException {
        this.addDirectory(directoryName, LIB_LOCATION, includes, this.addDefaultExcludes(excludes));
    }

    public void addMetaInf(File file) throws ArchiverException {
        this.addFile(file, METAINF_LOCATION + file.getName());
    }

    public void addMetaInf(File directoryName, String[] includes, String[] excludes) throws ArchiverException {
        this.addDirectory(directoryName, METAINF_LOCATION, includes, this.addDefaultExcludes(excludes));
    }

    public void addMule(File file) throws ArchiverException {
        this.addFile(file, MULE_LOCATION + file.getName());
    }

    public void addMule(File directoryName, String[] includes, String[] excludes) throws ArchiverException {
        this.addDirectory(directoryName, MULE_LOCATION, includes, this.addDefaultExcludes(excludes));
    }

    public void addPlugins(File file) throws ArchiverException {
        this.addFile(file, PLUGINS_LOCATION + file.getName());
    }

    public void addPlugins(File directoryName, String[] includes, String[] excludes) throws ArchiverException {
        this.addDirectory(directoryName, PLUGINS_LOCATION, includes, this.addDefaultExcludes(excludes));
    }

    public void addRootFile(File file) throws ArchiverException {
        this.addFile(file, ROOT_LOCATION + file.getName());
    }

    public void addRootDirectory(File directory) throws ArchiverException {
        this.addDirectory(directory, ROOT_LOCATION, null, this.addDefaultExcludes(null));
    }

    private String[] addDefaultExcludes(String[] excludes) {
        if (excludes == null || excludes.length == 0) {
            return DirectoryScanner.DEFAULTEXCLUDES;
        }
        String[] newExcludes = new String[excludes.length + DirectoryScanner.DEFAULTEXCLUDES.length];
        System.arraycopy(DirectoryScanner.DEFAULTEXCLUDES, 0, newExcludes, 0, DirectoryScanner.DEFAULTEXCLUDES.length);
        System.arraycopy(excludes, 0, newExcludes, DirectoryScanner.DEFAULTEXCLUDES.length, excludes.length);
        return newExcludes;
    }
}

