/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.artifact.archiver.internal.packaging;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.tools.artifact.archiver.internal.packaging.PackagingTypeFactory;
import org.mule.tools.artifact.archiver.internal.packaging.type.PackagingType;

public class PackageStructureValidator {
    private static PackagingType packagingType = PackagingTypeFactory.getDefaultPackaging();

    public PackageStructureValidator(PackagingType packagingType) {
        PackageStructureValidator.packagingType = packagingType;
    }

    public boolean hasExpectedStructure(File[] allFiles) {
        if (allFiles == null) {
            return false;
        }
        List<File> directories = Arrays.stream(allFiles).filter(file -> file.isDirectory()).collect(Collectors.toList());
        List<File> files = Arrays.stream(allFiles).filter(file -> file.isFile()).collect(Collectors.toList());
        return this.checkStructure(directories, packagingType.listDirectories()) && this.checkStructure(files, packagingType.listFiles());
    }

    private boolean checkStructure(List<File> children, Set<String> expectedChildren) {
        return children.stream().map(child -> child.getName()).collect(Collectors.toSet()).containsAll(expectedChildren);
    }
}

