/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.cloudconnect;

import java.io.File;
import java.io.InputStream;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.util.IOUtil;
import org.mule.tools.cloudconnect.MavenClassParserLog;
import org.mule.tools.cloudconnect.model.JavaModel;
import org.mule.tools.cloudconnect.parser.ClassParseException;
import org.mule.tools.cloudconnect.parser.ClassParser;
import org.mule.tools.cloudconnect.parser.ClassParserLog;
import org.mule.tools.cloudconnect.parser.qdox.QDoxClassParser;

public abstract class AbstractConnectorMojo
extends AbstractMojo {
    private File targetDirectory;
    private MavenProjectHelper projectHelper;
    protected MavenProject project;
    protected String schemaVersion;
    private ClassParser parser = new QDoxClassParser();

    public AbstractConnectorMojo() {
        this.parser.setLog((ClassParserLog)new MavenClassParserLog(this.getLog()));
    }

    public MavenProjectHelper getProjectHelper() {
        return this.projectHelper;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public File getTargetDirectory() {
        return this.targetDirectory;
    }

    protected void createDirectory(File directory) throws MojoExecutionException {
        if (!directory.exists() && !directory.mkdirs()) {
            throw new MojoExecutionException("Could not create " + directory.getAbsolutePath());
        }
    }

    protected JavaModel parseModel() throws MojoExecutionException {
        for (String sourceRoot : this.project.getCompileSourceRoots()) {
            this.parser.addSourceTree(new File(sourceRoot));
        }
        InputStream input = null;
        try {
            String sourceRoot;
            sourceRoot = this.parser.parse();
            return sourceRoot;
        }
        catch (ClassParseException cpe) {
            throw new MojoExecutionException("Error while parsing ", (Exception)((Object)cpe));
        }
        finally {
            IOUtil.close(input);
        }
    }

    public ClassParser getParser() {
        return this.parser;
    }

    protected String determineNamespaceIdentifierSuffixFromSchemaFilename(String schemaFilename) throws MojoExecutionException {
        if (!schemaFilename.startsWith("mule-")) {
            throw new MojoExecutionException("schemaFilename must start with 'mule-'");
        }
        if (!schemaFilename.endsWith(".xsd")) {
            throw new MojoExecutionException("schemaFilename must end with the .xsd extension");
        }
        String suffix = schemaFilename.replace("mule-", "");
        suffix = suffix.replace(".xsd", "");
        return suffix;
    }

    protected void createAndAttachGeneratedSourcesDirectory() throws MojoExecutionException {
        File sourceDirectory = this.generatedSourcesDirectory();
        this.createDirectory(sourceDirectory);
        this.getProject().addCompileSourceRoot(sourceDirectory.getAbsolutePath());
        File resourceDirectory = this.generatedResourcesDirectory();
        Resource testResource = new Resource();
        testResource.setDirectory(resourceDirectory.getAbsolutePath());
        this.getProject().addTestResource(testResource);
    }

    protected File generatedSourcesDirectory() {
        return new File(this.getTargetDirectory(), "generated-sources/mule");
    }

    protected File generatedResourcesDirectory() {
        return new File(this.getTargetDirectory(), "generated-resources/mule");
    }

    protected String getSchemaVersion() {
        return this.schemaVersion;
    }
}

