/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.cloudconnect;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.IOUtil;
import org.mule.tools.cloudconnect.AbstractConnectorMojo;
import org.mule.tools.cloudconnect.generator.BeanDefinitionParserGenerator;
import org.mule.tools.cloudconnect.generator.EnumTransformerGenerator;
import org.mule.tools.cloudconnect.generator.MessageProcessorGenerator;
import org.mule.tools.cloudconnect.generator.NamespaceHandlerGenerator;
import org.mule.tools.cloudconnect.generator.RegistryBootstrapGenerator;
import org.mule.tools.cloudconnect.generator.SpringNamespaceHandlerGenerator;
import org.mule.tools.cloudconnect.generator.TransformerMessageProcessorGenerator;
import org.mule.tools.cloudconnect.model.JavaClass;
import org.mule.tools.cloudconnect.model.JavaMethod;
import org.mule.tools.cloudconnect.model.JavaModel;
import org.mule.tools.cloudconnect.model.JavaType;

public class NamespaceHandlerGenerateMojo
extends AbstractConnectorMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        this.createAndAttachGeneratedSourcesDirectory();
        JavaModel model = this.parseModel();
        ArrayList<JavaClass> classes = new ArrayList<JavaClass>();
        HashSet enums = new HashSet();
        for (JavaClass javaClass : model.getClasses()) {
            if (!javaClass.isConnector()) continue;
            classes.add(javaClass);
            enums.addAll(javaClass.getEnums());
            NamespaceHandlerGenerator generator = new NamespaceHandlerGenerator();
            generator.setJavaClass(javaClass);
            OutputStream output = null;
            try {
                output = this.openNamespaceHandlerFileStream(javaClass.getNamespaceHandlerPackage(), javaClass.getNamespaceHandlerName());
                generator.generate(output);
            }
            catch (IOException iox) {
                try {
                    throw new MojoExecutionException("Error while generating namespace handler", (Exception)iox);
                }
                catch (Throwable throwable) {
                    IOUtil.close(output);
                    throw throwable;
                }
            }
            IOUtil.close((OutputStream)output);
            BeanDefinitionParserGenerator beanDefinitionParserGenerator = new BeanDefinitionParserGenerator();
            beanDefinitionParserGenerator.setJavaClass(javaClass);
            MessageProcessorGenerator messageProcessorGenerator = new MessageProcessorGenerator();
            messageProcessorGenerator.setJavaClass(javaClass);
            TransformerMessageProcessorGenerator transformerMessageProcessorGenerator = new TransformerMessageProcessorGenerator();
            transformerMessageProcessorGenerator.setJavaClass(javaClass);
            for (JavaMethod method : javaClass.getMethods()) {
                if (method.isOperation()) {
                    beanDefinitionParserGenerator.setJavaMethod(method);
                    try {
                        output = this.openNamespaceHandlerFileStream(javaClass.getNamespaceHandlerPackage(), method.getBeanDefinitionParserName());
                        beanDefinitionParserGenerator.generate(output);
                    }
                    catch (IOException iox) {
                        throw new MojoExecutionException("Error while generating bean definition parser", (Exception)iox);
                    }
                    finally {
                        IOUtil.close((OutputStream)output);
                    }
                    messageProcessorGenerator.setJavaMethod(method);
                    try {
                        output = this.openNamespaceHandlerFileStream(javaClass.getNamespaceHandlerPackage(), method.getMessageProcessorName());
                        messageProcessorGenerator.generate(output);
                        continue;
                    }
                    catch (IOException iox) {
                        throw new MojoExecutionException("Error while generating message processor", (Exception)iox);
                    }
                    finally {
                        IOUtil.close((OutputStream)output);
                        continue;
                    }
                }
                if (!method.isTransformer()) continue;
                transformerMessageProcessorGenerator.setJavaMethod(method);
                try {
                    output = this.openNamespaceHandlerFileStream(javaClass.getNamespaceHandlerPackage(), method.getMessageProcessorName());
                    transformerMessageProcessorGenerator.generate(output);
                }
                catch (IOException iox) {
                    throw new MojoExecutionException("Error while generating transformer message processor", (Exception)iox);
                }
                finally {
                    IOUtil.close((OutputStream)output);
                }
            }
            EnumTransformerGenerator enumTransformerGenerator = new EnumTransformerGenerator();
            for (JavaType enumType : javaClass.getEnums()) {
                enumTransformerGenerator.setJavaType(enumType);
                try {
                    output = this.openNamespaceHandlerFileStream(enumType.getTransformerPackage(), enumType.getTransformerName());
                    enumTransformerGenerator.generate(output);
                }
                catch (IOException iox) {
                    throw new MojoExecutionException("Error while generating enum transformer", (Exception)iox);
                }
                finally {
                    IOUtil.close((OutputStream)output);
                }
            }
            SpringNamespaceHandlerGenerator springNamespaceHandlerGenerator = new SpringNamespaceHandlerGenerator();
            springNamespaceHandlerGenerator.setClasses(classes);
            try {
                output = this.openSpringNamespaceHandlerFileStream();
                springNamespaceHandlerGenerator.generate(output);
            }
            catch (IOException iox) {
                throw new MojoExecutionException("Error while generating spring schemas helper", (Exception)iox);
            }
            finally {
                IOUtil.close((OutputStream)output);
            }
            RegistryBootstrapGenerator registryBootstrapGenerator = new RegistryBootstrapGenerator();
            registryBootstrapGenerator.setEnums(enums);
            try {
                output = this.openRegistryBootstrapFileStream();
                registryBootstrapGenerator.generate(output);
            }
            catch (IOException iox) {
                throw new MojoExecutionException("Error while generating the registry bootstrap", (Exception)iox);
            }
            finally {
                IOUtil.close((OutputStream)output);
            }
        }
    }

    private File namespaceHandlerProjectRelativeFile(File namespaceHandler) {
        String namespaceHandlerPath = namespaceHandler.getAbsolutePath();
        String basedir = this.project.getBasedir().getAbsolutePath();
        String relativeNamespaceHandlerPath = namespaceHandlerPath.replace(basedir, "");
        relativeNamespaceHandlerPath = relativeNamespaceHandlerPath.substring(1);
        return new File(relativeNamespaceHandlerPath);
    }

    private OutputStream openNamespaceHandlerFileStream(String namespaceHandlerPackage, String namesapceHandlerName) throws IOException, MojoExecutionException {
        String directory = namespaceHandlerPackage.replace('.', File.separatorChar);
        File namespaceDirectory = new File(this.generatedSourcesDirectory(), directory);
        this.createDirectory(namespaceDirectory);
        File namespaceHandlerFile = new File(namespaceDirectory, namesapceHandlerName + ".java");
        return new FileOutputStream(namespaceHandlerFile);
    }

    private OutputStream openSpringNamespaceHandlerFileStream() throws IOException, MojoExecutionException {
        File metaInfDirectory = new File(this.generatedResourcesDirectory(), "META-INF");
        this.createDirectory(metaInfDirectory);
        File springSchemaFile = new File(metaInfDirectory, "spring.handlers");
        return new FileOutputStream(springSchemaFile);
    }

    private OutputStream openRegistryBootstrapFileStream() throws IOException, MojoExecutionException {
        File metaInfDirectory = new File(this.generatedResourcesDirectory(), "META-INF");
        File registryBootstrapDirectory = new File(metaInfDirectory, "services/org/mule/config");
        this.createDirectory(registryBootstrapDirectory);
        File registryBootstrapFile = new File(registryBootstrapDirectory, "registry-bootstrap.properties");
        return new FileOutputStream(registryBootstrapFile);
    }
}

