/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.cloudconnect;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.IOUtil;
import org.mule.tools.cloudconnect.AbstractConnectorMojo;
import org.mule.tools.cloudconnect.generator.SchemaGenerator;
import org.mule.tools.cloudconnect.generator.SpringSchemaGenerator;
import org.mule.tools.cloudconnect.model.JavaClass;
import org.mule.tools.cloudconnect.model.JavaModel;

public class SchemaGenerateMojo
extends AbstractConnectorMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        this.createAndAttachGeneratedSourcesDirectory();
        JavaModel model = this.parseModel();
        ArrayList<JavaClass> classes = new ArrayList<JavaClass>();
        OutputStream output = null;
        for (JavaClass javaClass : model.getClasses()) {
            if (javaClass.isConnector()) {
                classes.add(javaClass);
                SchemaGenerator generator = new SchemaGenerator();
                generator.setJavaClass(javaClass);
                try {
                    output = this.openSchemaFileStream("mule-" + javaClass.getNamespacePrefix() + ".xsd");
                    generator.generate(output);
                }
                catch (IOException iox) {
                    throw new MojoExecutionException("Error while generating schema", (Exception)iox);
                }
                finally {
                    IOUtil.close((OutputStream)output);
                }
            }
            SpringSchemaGenerator springSchemaGenerator = new SpringSchemaGenerator();
            springSchemaGenerator.setClasses(classes);
            springSchemaGenerator.setSchemaVersion(this.getSchemaVersion());
            try {
                output = this.openSpringSchemaFileStream();
                springSchemaGenerator.generate(output);
            }
            catch (IOException iox) {
                throw new MojoExecutionException("Error while generating schema", (Exception)iox);
            }
            finally {
                IOUtil.close((OutputStream)output);
            }
        }
    }

    private OutputStream openSchemaFileStream(String schemaFilename) throws IOException, MojoExecutionException {
        File metaInfDirectory = this.getResourcesMetaInf();
        File schemaFile = new File(metaInfDirectory, schemaFilename);
        return new FileOutputStream(schemaFile);
    }

    private OutputStream openSpringSchemaFileStream() throws IOException, MojoExecutionException {
        File metaInfDirectory = this.getResourcesMetaInf();
        File springSchemaFile = new File(metaInfDirectory, "spring.schemas");
        return new FileOutputStream(springSchemaFile);
    }

    private File getResourcesMetaInf() throws MojoExecutionException {
        File metaInfDirectory = new File(this.generatedResourcesDirectory(), "META-INF");
        this.createDirectory(metaInfDirectory);
        return metaInfDirectory;
    }
}

