/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.cloudconnect;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.util.IOUtil;
import org.mule.tools.cloudconnect.model.JavaModel;
import org.mule.tools.cloudconnect.parser.qdox.QDoxModel;

public abstract class AbstractConnectorMojo
extends AbstractMojo {
    private File targetDirectory;
    private MavenProjectHelper projectHelper;
    protected MavenProject project;

    public MavenProjectHelper getProjectHelper() {
        return this.projectHelper;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public File getTargetDirectory() {
        return this.targetDirectory;
    }

    protected void createDirectory(File directory) throws MojoExecutionException {
        if (!directory.exists() && !directory.mkdirs()) {
            throw new MojoExecutionException("Could not create " + directory.getAbsolutePath());
        }
    }

    protected JavaModel parseModel() throws MojoExecutionException {
        QDoxModel model = new QDoxModel();
        ArrayList<File> sourceRoots = new ArrayList<File>();
        for (String sourceRoot : this.project.getCompileSourceRoots()) {
            sourceRoots.add(new File(sourceRoot));
        }
        InputStream input = null;
        model.parse(sourceRoots);
        IOUtil.close(input);
        return model;
    }

    protected void createAndAttachGeneratedSourcesDirectory() throws MojoExecutionException {
        File sourceDirectory = this.generatedSourcesDirectory();
        this.createDirectory(sourceDirectory);
        this.getProject().addCompileSourceRoot(sourceDirectory.getAbsolutePath());
        File resourceDirectory = this.generatedResourcesDirectory();
        Resource generatedResources = new Resource();
        generatedResources.setDirectory(resourceDirectory.getAbsolutePath());
        this.getProject().addResource(generatedResources);
    }

    protected File generatedSourcesDirectory() {
        return new File(this.getTargetDirectory(), "generated-sources/mule");
    }

    protected File generatedResourcesDirectory() {
        return new File(this.getTargetDirectory(), "generated-resources/mule");
    }
}

