/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.cloudconnect;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.IOUtil;
import org.mule.tools.cloudconnect.AbstractConnectorMojo;
import org.mule.tools.cloudconnect.generator.ReadmeGenerator;
import org.mule.tools.cloudconnect.model.JavaClass;
import org.mule.tools.cloudconnect.model.JavaModel;

public class ReadmeGenerateMojo
extends AbstractConnectorMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        this.createAndAttachGeneratedSourcesDirectory();
        JavaModel model = this.parseModel();
        ArrayList classes = new ArrayList();
        OutputStream output = null;
        ReadmeGenerator readmeGenerator = new ReadmeGenerator();
        readmeGenerator.setName(this.project.getName());
        readmeGenerator.setDescription(this.project.getDescription());
        readmeGenerator.setArtifactId(this.project.getArtifactId());
        readmeGenerator.setGroupId(this.project.getGroupId());
        readmeGenerator.setVersion(this.project.getVersion());
        if (this.project.getDistributionManagement() == null || this.project.getDistributionManagement().getRepository() == null) {
            throw new MojoExecutionException("No distribution management section in POM");
        }
        readmeGenerator.setRepoId(this.project.getDistributionManagement().getRepository().getId());
        readmeGenerator.setRepoName(this.project.getDistributionManagement().getRepository().getName());
        readmeGenerator.setRepoUrl(this.project.getDistributionManagement().getRepository().getUrl().replace("dav:", ""));
        readmeGenerator.setRepoLayout(this.project.getDistributionManagement().getRepository().getLayout());
        for (JavaClass javaClass : model.getClasses()) {
            if (!javaClass.isConnector()) continue;
            readmeGenerator.setJavaClass(javaClass);
            break;
        }
        try {
            output = this.openReadmeFilestream("README.md");
            readmeGenerator.generate(output);
        }
        catch (IOException iox) {
            throw new MojoExecutionException("Error while generating readme", (Exception)iox);
        }
        finally {
            IOUtil.close((OutputStream)output);
        }
    }

    private OutputStream openReadmeFilestream(String readmeFilename) throws IOException, MojoExecutionException {
        File schemaFile = new File(this.project.getBasedir(), readmeFilename);
        return new FileOutputStream(schemaFile);
    }
}

