/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.cxf.utils.policy;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.EndpointImpl;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.ws.policy.PolicyInterceptorProvider;
import org.apache.cxf.ws.policy.PolicyInterceptorProviderRegistry;

public class PolicyRegistrator {
    private List<PolicyInterceptorProvider> policyProviders = new ArrayList<PolicyInterceptorProvider>();

    public void addPolicyProvider(PolicyInterceptorProvider policyPorvider) {
        this.policyProviders.add(policyPorvider);
    }

    public void addAllPolicyProviders(List<PolicyInterceptorProvider> policyProvidersList) {
        this.policyProviders.addAll(policyProvidersList);
    }

    public List<PolicyInterceptorProvider> getPolicyProviders() {
        return this.policyProviders;
    }

    public void clearPolicyProviders() {
        this.policyProviders.clear();
    }

    public Client registerPolicyProviders(Object servicePort) {
        Validate.notNull((Object)servicePort, (String)"The service port should not be null");
        Client client = ClientProxy.getClient((Object)servicePort);
        return this.registerPolicyProviders(client);
    }

    public Client registerPolicyProviders(Client client) {
        Validate.notEmpty(this.policyProviders, (String)"There are no policy providers to register, please add them");
        Validate.notNull((Object)client, (String)"The client port should not be null");
        Bus bus = ((EndpointImpl)client.getEndpoint()).getBus();
        PolicyInterceptorProviderRegistry pipr = (PolicyInterceptorProviderRegistry)bus.getExtension(PolicyInterceptorProviderRegistry.class);
        if (pipr != null) {
            for (PolicyInterceptorProvider policyProvider : this.policyProviders) {
                pipr.register(policyProvider);
            }
        }
        return client;
    }
}

