/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.cxf.utils.security;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.spnego.SpnegoClientAction;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;
import sun.security.mule.jgss.GSSManagerImpl;
import sun.security.mule.jgss.GSSNameImpl;
import sun.security.mule.jgss.krb5.Krb5NameElement;
import sun.security.mule.krb5.Config;

public class XRMSpnegoClientAction
implements SpnegoClientAction {
    private Log log = LogFactory.getLog(XRMSpnegoClientAction.class);
    protected String serviceName;
    protected GSSContext secContext;
    protected boolean mutualAuth;
    private Config kerberosConfig;

    public XRMSpnegoClientAction(Config kerberosConfig) {
        this.kerberosConfig = kerberosConfig;
    }

    public void setMutualAuth(boolean mutualAuthentication) {
        this.mutualAuth = mutualAuthentication;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public GSSContext getContext() {
        return this.secContext;
    }

    public byte[] run() {
        this.log.info((Object)"Starting negotiaton for Kerberos TGT");
        try {
            Oid oid = new Oid("1.3.6.1.5.5.2");
            GSSManagerImpl gssManager = new GSSManagerImpl(this.kerberosConfig);
            Krb5NameElement krb5NameElement = Krb5NameElement.getInstance(this.serviceName, null, this.kerberosConfig);
            GSSNameImpl gssSerive = new GSSNameImpl(gssManager, krb5NameElement);
            this.secContext = gssManager.createContext(gssSerive, oid, null, 0);
            this.secContext.requestMutualAuth(this.mutualAuth);
            this.secContext.requestCredDeleg(Boolean.FALSE);
            byte[] token = new byte[]{};
            return this.secContext.initSecContext(token, 0, token.length);
        }
        catch (GSSException e) {
            this.log.error((Object)"Error in obtaining a Kerberos TGT", (Throwable)e);
            return null;
        }
    }
}

